/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.google.common.collect.Maps;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.filetypes.FileTypeUtils;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.swt.text.RegexStyledTextDecorator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;

public class LinkToFileStyledTextDecorator
implements IStyledTextDecorator {
    private final Map<String, Object> nameToFile;
    private final IWorkbenchSite site;
    private List<ReviewFileLinkStyledTextDecorator> decorators;

    public LinkToFileStyledTextDecorator(Map<String, ? extends Object> pathToFile, IWorkbenchSite site) {
        this.nameToFile = Maps.newHashMapWithExpectedSize((int)pathToFile.size());
        for (Map.Entry<String, ? extends Object> entry : pathToFile.entrySet()) {
            this.nameToFile.put(FilenameUtils.getName((String)entry.getKey()).toLowerCase(), entry.getValue());
        }
        this.site = site;
        String extraKeywordChars = "";
        Set patterns = FileTypeUtils.compileKeywordPatterns(this.nameToFile.keySet(), (boolean)false, (String)extraKeywordChars);
        this.decorators = new ArrayList<ReviewFileLinkStyledTextDecorator>(patterns.size());
        for (Pattern pattern : patterns) {
            this.decorators.add(new ReviewFileLinkStyledTextDecorator(pattern));
        }
    }

    @Override
    public void decorate(StyledText text) {
        for (IStyledTextDecorator iStyledTextDecorator : this.decorators) {
            iStyledTextDecorator.decorate(text);
        }
    }

    private void openFile(Object file) {
        try {
            PlatformUIUtils.executeCommand((IServiceLocator)this.site, "com.smartbear.collaborator.ui.commands.OpenReviewFile", null, Collections.singletonList(file));
        }
        catch (ExecutionException e) {
            CollaboratorUI.openError(this.site.getShell(), "Error opening file", e, false, true);
        }
    }

    private class ReviewFileLinkStyledTextDecorator
    extends RegexStyledTextDecorator {
        public ReviewFileLinkStyledTextDecorator(Pattern pattern) {
            super(pattern);
        }

        @Override
        protected void decorate(StyledText text, MatchResult matchResult) {
            final Object file = LinkToFileStyledTextDecorator.this.nameToFile.get(matchResult.group().toLowerCase());
            SwtUtils.addLink(text, matchResult.start(), matchResult.end(), "Open in Compare Editor", new Runnable(){

                @Override
                public void run() {
                    LinkToFileStyledTextDecorator.this.openFile(file);
                }
            });
        }
    }
}

