/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.smartbear.ccollab.datamodel.client.FileSource;
import com.smartbear.ccollab.datamodel.client.IVersion;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.review.compare.ServerCompareVersion;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.commons.ObjectUtils;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LiveUrlViewer
extends Viewer {
    private final Browser browser;
    private Object input;

    public LiveUrlViewer(Composite parent) {
        this.browser = new Browser(parent, SwtUtils.BASE_COMPOSITE_STYLE);
    }

    public Control getControl() {
        return this.browser;
    }

    public void setInput(Object input) {
        this.input = input;
        this.refresh();
    }

    public final Object getInput() {
        return this.input;
    }

    public void refresh() {
        if (this.input == null) {
            return;
        }
        if (!(this.input instanceof ICompareInput)) {
            CollaboratorUI.log("Invalid input - expected ICompareInput but was " + this.input, null);
            return;
        }
        ICompareInput compareInput = (ICompareInput)this.input;
        ITypedElement element = (ITypedElement)ObjectUtils.defaultIfNull((Object)compareInput.getLeft(), (Object)compareInput.getRight());
        if (!(element instanceof ServerCompareVersion)) {
            CollaboratorUI.log("Invalid diff element - expected ServerCompareVersion but was " + element, null);
            return;
        }
        ServerCompareVersion compareVersion = (ServerCompareVersion)element;
        IVersion version = compareVersion.getVersion();
        if (version.getFileSource() != FileSource.URL && version.getFileSource() != FileSource.SIMULINK) {
            CollaboratorUI.log("Invalid version for viewer - FileSource must be URL", null);
            return;
        }
        String url = version.getPath();
        this.browser.setUrl(url);
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }
}

