/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.smartbear.ccollab.datamodel.diff.VersionDiffUtils;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.ui.review.compare.ConcreteRangeDifference;
import com.smartbear.collaborator.ui.review.compare.ExtensibleDocumentMerger;
import com.smartbear.diffs.Diff;
import com.smartbear.util.commons.ObjectUtils;
import java.util.ArrayList;
import org.eclipse.compare.internal.merge.DocumentMerger;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.core.runtime.IProgressMonitor;

public class SBDocumentMerger
extends ExtensibleDocumentMerger {
    private static final RangeDifference[] EMPTY_RANGE_DIFFERENCE_ARRAY = new RangeDifference[0];

    public SBDocumentMerger(DocumentMerger.IDocumentMergerInput input) {
        super(input);
    }

    @Override
    protected RangeDifference[] findRanges(IProgressMonitor pm, String[] ancestorLines, String[] leftLines, String[] rightLines) {
        Preconditions.checkArgument((ancestorLines.length == 0 ? 1 : 0) != 0, (Object)"Three-way diff not supported");
        boolean isIgnoreWhitespace = PrefsHelper.getPrefs().getIgnoreWhiteSpaceInEclipseEditor();
        boolean isIngoreSequenceNumber = PrefsHelper.getPrefs().getIgnoreSequenceNumberInEclipseEditor();
        Diff[] diffs = VersionDiffUtils.computeDifferences((String[])rightLines, (String[])leftLines, (boolean)isIgnoreWhitespace, (boolean)false, (boolean)isIngoreSequenceNumber);
        int leftIdx = 0;
        int rightIdx = 0;
        ArrayList ranges = Lists.newArrayListWithCapacity((int)diffs.length);
        for (Diff diff : diffs) {
            if (diff.currStartIdx > leftIdx && diff.prevStartIdx > rightIdx) {
                int length = diff.prevStartIdx - rightIdx;
                assert (diff.currStartIdx - leftIdx == length);
                ranges.add(new ConcreteRangeDifference(0, rightIdx, length, leftIdx, length));
            }
            ranges.add(new ConcreteRangeDifference(SBDocumentMerger.getRangeDifferenceChangeKind(diff), diff.prevStartIdx, diff.prevCount, diff.currStartIdx, diff.currCount));
            leftIdx = diff.currStartIdx + diff.currCount;
            rightIdx = diff.prevStartIdx + diff.prevCount;
        }
        if (leftIdx < leftLines.length || rightIdx < rightLines.length) {
            int length = rightLines.length - rightIdx;
            assert (leftLines.length - leftIdx == length);
            ranges.add(new ConcreteRangeDifference(0, rightIdx, length, leftIdx, length));
        }
        return ranges.toArray(EMPTY_RANGE_DIFFERENCE_ARRAY);
    }

    private boolean isIgnoreWhitespace() {
        return (Boolean)ObjectUtils.defaultIfNull((Object)((Boolean)this.getCompareConfiguration().getProperty("IGNORE_WHITESPACE")), (Object)false);
    }

    static int getRangeDifferenceChangeKind(Diff diff) {
        if (diff.isDeletion()) {
            return 2;
        }
        if (diff.isInsertion()) {
            return 3;
        }
        if (diff.isModification()) {
            return 2;
        }
        throw new RuntimeException("Unrecognized diff type");
    }
}

