/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.compare;

import com.smartbear.ccollab.datamodel.client.IComment;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.IDefect;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.LineLocator;
import com.smartbear.ccollab.datamodel.client.LocatorType;
import com.smartbear.ccollab.datamodel.client.listener.IConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.IConversationProviderListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ConversationProviderAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewConversationAdapter;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import com.smartbear.collaborator.ui.ActivityListener;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.review.IConversationContextListener;
import com.smartbear.collaborator.ui.review.compare.ContentMergeCompareViewer;
import com.smartbear.collaborator.ui.review.compare.ConversationAnnotation;
import com.smartbear.collaborator.ui.review.compare.ICompareModel;
import com.smartbear.collaborator.ui.review.compare.ICompareModelListener;
import com.smartbear.collaborator.ui.review.compare.SBDocumentMerger;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.CompositeStyledTextDecorator;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.swt.text.RegexStyledTextDecorator;
import com.smartbear.util.NumberUtils;
import com.smartbear.util.SmartBearUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.merge.DocumentMerger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class TextMergeCompareViewer<V extends TextMergeViewer>
extends ContentMergeCompareViewer<V> {
    private static final int ANNOTATION_WIDTH = 16;
    private static final Field MERGER_FIELD;
    private static final Method HANDLE_SELECTION_CHANGED_METHOD;

    protected TextMergeCompareViewer(V viewer, ICompareModel model, IReusableEditor editor) {
        super(viewer, model, editor);
        TextMergeCompareViewer.setDiffAlgorithm(viewer);
        if (model.isAfterVersionLocalFile()) {
            model.addCompareModelListener(new ICompareModelListener(){

                @Override
                public void afterFileModifiedChanged(boolean modified) {
                    for (IConversationContextListener listener : TextMergeCompareViewer.this.conversationContextListeners.getListeners()) {
                        listener.whyNotAllowedToStartNewConversationChanged(TextMergeCompareViewer.this.getWhyNotAllowedToStartNewConversation());
                    }
                }
            });
        }
        MergeSourceViewer leftMergeSourceViewer = this.getMergeSourceViewer(ContentMergeCompareViewer.Side.LEFT);
        MergeSourceViewer rightMergeSourceViewer = this.getMergeSourceViewer(ContentMergeCompareViewer.Side.RIGHT);
        if (leftMergeSourceViewer != null) {
            TextMergeCompareViewer.showLineNumbers(leftMergeSourceViewer);
        }
        if (rightMergeSourceViewer != null) {
            TextMergeCompareViewer.showLineNumbers(rightMergeSourceViewer);
        }
        final SourceViewer leftSourceViewer = this.getSourceViewer(ContentMergeCompareViewer.Side.LEFT);
        SourceViewer rightSourceViewer = this.getSourceViewer(ContentMergeCompareViewer.Side.RIGHT);
        if (leftSourceViewer == null || rightSourceViewer == null) {
            CollaboratorUI.log("Could not add line-based controls to diff viewer", null);
            return;
        }
        CompositeRuler compositeRuler = TextMergeCompareViewer.getVerticalRuler(leftSourceViewer);
        if (compositeRuler == null) {
            CollaboratorUI.log("Could not find composite ruler for SourceViewer " + leftSourceViewer, null);
        } else {
            ModifiableAnnotationModel annotationModel = new ModifiableAnnotationModel();
            AnnotationRulerColumn annotationColumn = new AnnotationRulerColumn((IAnnotationModel)annotationModel, 16, (IAnnotationAccess)new DefaultMarkerAnnotationAccess()){

                public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
                    Control control = super.createControl(parentRuler, parentControl);
                    control.setBackground(leftSourceViewer.getTextWidget().getBackground());
                    return control;
                }

                protected void mouseClicked(int rulerLine) {
                    LineLocator locator = new LineLocator(rulerLine + 1);
                    TextMergeCompareViewer.this.fireLocatorSelected((ILocator)locator);
                }
            };
            compositeRuler.addDecorator(0, (IVerticalRulerColumn)annotationColumn);
            annotationColumn.addAnnotationType((Object)"com.smartbear.collaborator.ui.ConversationAnnotation");
            leftSourceViewer.addTextInputListener((ITextInputListener)new AnnotationListener(model, annotationModel));
        }
        this.hookLocatorSelectionEvents(leftSourceViewer, ContentMergeCompareViewer.Side.LEFT);
        this.hookLocatorSelectionEvents(rightSourceViewer, ContentMergeCompareViewer.Side.RIGHT);
        ActivityListener activityListener = new ActivityListener((ClientModelRefreshJob)model.getRefreshJob());
        leftSourceViewer.addViewportListener((IViewportListener)activityListener);
        rightSourceViewer.addViewportListener((IViewportListener)activityListener);
    }

    @Override
    public ILocator getCurrentLocator() {
        SourceViewer left = this.getSourceViewer(ContentMergeCompareViewer.Side.LEFT);
        if (left != null) {
            return this.getCurrentLocator(left, ContentMergeCompareViewer.Side.LEFT);
        }
        return null;
    }

    private void hookLocatorSelectionEvents(final SourceViewer sourceViewer, final ContentMergeCompareViewer.Side side) {
        sourceViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TextMergeCompareViewer.this.fireLocatorSelected(TextMergeCompareViewer.this.getCurrentLocator(sourceViewer, side));
            }
        });
        sourceViewer.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TextMergeCompareViewer.this.fireLocatorSelected(TextMergeCompareViewer.this.getCurrentLocator(sourceViewer, side));
            }

            public void mouseUp(MouseEvent e) {
                TextMergeCompareViewer.this.fireLocatorSelected(TextMergeCompareViewer.this.getCurrentLocator(sourceViewer, side));
            }
        });
        sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int offset = sourceViewer.getTextWidget().getCaretOffset();
                if (offset == 0) {
                    return;
                }
                TextMergeCompareViewer.this.fireLocatorSelected(TextMergeCompareViewer.this.getCurrentLocator(sourceViewer, side));
            }
        });
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        super.addKeyListener(listener);
        this.addKeyListener(listener, ContentMergeCompareViewer.Side.RIGHT);
        this.addKeyListener(listener, ContentMergeCompareViewer.Side.LEFT);
    }

    private void addKeyListener(KeyListener listener, ContentMergeCompareViewer.Side side) {
        SourceViewer sourceViewer = this.getSourceViewer(side);
        if (sourceViewer != null && !sourceViewer.isEditable()) {
            sourceViewer.getTextWidget().addKeyListener(listener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        super.removeKeyListener(listener);
        this.removeKeyListener(listener, ContentMergeCompareViewer.Side.RIGHT);
        this.removeKeyListener(listener, ContentMergeCompareViewer.Side.LEFT);
    }

    private void removeKeyListener(KeyListener listener, ContentMergeCompareViewer.Side side) {
        SourceViewer sourceViewer = this.getSourceViewer(side);
        if (sourceViewer != null) {
            sourceViewer.getTextWidget().removeKeyListener(listener);
        }
    }

    @Override
    public String getWhyNotAllowedToStartNewConversation() {
        return this.getModel().isAfterFileModified() ? "Not allowed to start new conversations on modified local file - upload the file to the Review first" : null;
    }

    @Override
    public boolean allowsLabelLocators() {
        return false;
    }

    @Override
    public IStyledTextDecorator getUserTextDecorator() {
        CompositeStyledTextDecorator decorator = new CompositeStyledTextDecorator();
        decorator.add(super.getUserTextDecorator());
        decorator.add(new RegexStyledTextDecorator(Pattern.compile("\\bline\\s*(?:\\s|#)\\s*(\\d+)\\b", 2)){

            @Override
            protected void decorate(StyledText text, MatchResult matchResult) {
                final int line = NumberUtils.parseInteger((String)matchResult.group(1), (int)-1);
                if (line < 0) {
                    return;
                }
                SwtUtils.addLink(text, matchResult.start(), matchResult.end(), "Go to Line " + line, new Runnable(){

                    @Override
                    public void run() {
                        TextMergeCompareViewer.this.selectAndReveal((ILocator)new LineLocator(line));
                    }
                });
            }
        });
        return decorator;
    }

    private static DocumentMerger getDocumentMerger(TextMergeViewer viewer) {
        if (MERGER_FIELD == null) {
            return null;
        }
        try {
            return (DocumentMerger)MERGER_FIELD.get(viewer);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setDiffAlgorithm(TextMergeViewer viewer) {
        if (MERGER_FIELD == null) {
            return;
        }
        try {
            DocumentMerger eclipseMerger = TextMergeCompareViewer.getDocumentMerger(viewer);
            Field inputField = DocumentMerger.class.getDeclaredField("fInput");
            inputField.setAccessible(true);
            DocumentMerger.IDocumentMergerInput input = (DocumentMerger.IDocumentMergerInput)inputField.get(eclipseMerger);
            SBDocumentMerger merger = new SBDocumentMerger(input);
            MERGER_FIELD.set(viewer, (Object)merger);
        }
        catch (Exception e) {
            CollaboratorUI.log("Error replacing Eclipse diff algorithm", e);
            return;
        }
    }

    private MergeSourceViewer getMergeSourceViewer(ContentMergeCompareViewer.Side side) {
        MergeSourceViewer mergeSourceViewer;
        Field field;
        String fieldName = side.accept(new ContentMergeCompareViewer.ISideVisitor<String>(){

            @Override
            public String visitLeft() {
                return "fLeft";
            }

            @Override
            public String visitRight() {
                return "fRight";
            }
        });
        try {
            field = TextMergeViewer.class.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error finding " + fieldName + " in TextMergeViewer", e);
            return null;
        }
        catch (NoSuchFieldException e) {
            CollaboratorUI.log("Error finding " + fieldName + " in TextMergeViewer", e);
            return null;
        }
        field.setAccessible(true);
        try {
            mergeSourceViewer = (MergeSourceViewer)field.get(this.getViewer());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            CollaboratorUI.log("Error getting " + fieldName + " in TextMergeViewer", e);
            return null;
        }
        return mergeSourceViewer;
    }

    private SourceViewer getSourceViewer(ContentMergeCompareViewer.Side side) {
        SourceViewer sourceViewer;
        MergeSourceViewer mergeSourceViewer = this.getMergeSourceViewer(side);
        if (mergeSourceViewer != null && (sourceViewer = mergeSourceViewer.getSourceViewer()) != null) {
            return sourceViewer;
        }
        return null;
    }

    private static CompositeRuler getVerticalRuler(SourceViewer sourceViewer) {
        IVerticalRuler verticalRuler;
        Method getVerticalRulerMethod;
        try {
            getVerticalRulerMethod = SourceViewer.class.getDeclaredMethod("getVerticalRuler", new Class[0]);
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error finding getVerticalRuler() in SourceViewer", e);
            return null;
        }
        catch (NoSuchMethodException e) {
            CollaboratorUI.log("Error finding getVerticalRuler() in SourceViewer", e);
            return null;
        }
        getVerticalRulerMethod.setAccessible(true);
        try {
            verticalRuler = (IVerticalRuler)getVerticalRulerMethod.invoke((Object)sourceViewer, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            CollaboratorUI.log("Error calling getVerticalRuler() in SourceViewer", e);
            return null;
        }
        if (!(verticalRuler instanceof CompositeRuler)) {
            CollaboratorUI.log("Could not get composite vertical ruler for diff: " + verticalRuler, null);
            return null;
        }
        return (CompositeRuler)verticalRuler;
    }

    private static void showLineNumbers(MergeSourceViewer mergeSourceViewer) {
        Method toggleLineNumberRulerMethod;
        if (EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler")) {
            return;
        }
        try {
            toggleLineNumberRulerMethod = MergeSourceViewer.class.getDeclaredMethod("toggleLineNumberRuler", new Class[0]);
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error finding toggleLineNumberRuler() in MergeSourceViewer", e);
            return;
        }
        catch (NoSuchMethodException e) {
            CollaboratorUI.log("Error finding toggleLineNumberRuler() in MergeSourceViewer", e);
            return;
        }
        toggleLineNumberRulerMethod.setAccessible(true);
        try {
            toggleLineNumberRulerMethod.invoke((Object)mergeSourceViewer, new Object[0]);
        }
        catch (IllegalAccessException e) {
            CollaboratorUI.log("Error invoking MergeSourceViewer.toggleLineNumberRuler()", e);
            return;
        }
        catch (InvocationTargetException e) {
            CollaboratorUI.log("Error invoking MergeSourceViewer.toggleLineNumberRuler()", e);
            return;
        }
    }

    private ILocator getCurrentLocator(SourceViewer sourceViewer, ContentMergeCompareViewer.Side side) {
        DocumentMerger documentMerger;
        int lineNumber;
        int offset = sourceViewer.getTextWidget().getCaretOffset();
        try {
            lineNumber = sourceViewer.getDocument().getLineOfOffset(offset);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("Bad document location: " + offset, ex);
        }
        if (side == ContentMergeCompareViewer.Side.RIGHT && (documentMerger = TextMergeCompareViewer.getDocumentMerger((TextMergeViewer)this.getViewer())) != null) {
            int virtualPos = documentMerger.realToVirtualPosition('R', lineNumber);
            lineNumber = documentMerger.virtualToRealPosition('L', virtualPos);
        }
        return new LineLocator(lineNumber + 1);
    }

    @Override
    protected void selectAndReveal(ILocator locator) {
        int offset;
        if (locator.getType() != LocatorType.LINE) {
            return;
        }
        LineLocator lineLocator = (LineLocator)locator;
        int leftLine = lineLocator.getLineNumber() - 1;
        MergeSourceViewer mergeSourceViewer = this.getMergeSourceViewer(ContentMergeCompareViewer.Side.LEFT);
        if (mergeSourceViewer == null) {
            return;
        }
        SourceViewer sourceViewer = mergeSourceViewer.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        try {
            offset = sourceViewer.getDocument().getLineOffset(leftLine);
        }
        catch (BadLocationException e) {
            CollaboratorUI.log("Bad location: " + lineLocator, e);
            return;
        }
        sourceViewer.setSelection((ISelection)new TextSelection(offset, 0), true);
        if (HANDLE_SELECTION_CHANGED_METHOD != null) {
            try {
                HANDLE_SELECTION_CHANGED_METHOD.invoke(this.getViewer(), mergeSourceViewer);
            }
            catch (IllegalAccessException e) {
                CollaboratorUI.log("Error calling handleSelectionChanged(...)", e);
            }
            catch (InvocationTargetException e) {
                SmartBearUtils.rethrowIfUnchecked((Throwable)e.getTargetException());
                CollaboratorUI.log("Error calling handleSelectionChanged", e.getTargetException());
            }
        }
    }

    public static TextMergeCompareViewer<TextMergeViewer> create(TextMergeViewer viewer, ICompareModel model, IReusableEditor editor) {
        return new TextMergeCompareViewer<TextMergeViewer>(viewer, model, editor);
    }

    static {
        Field mergerField = null;
        try {
            mergerField = TextMergeViewer.class.getDeclaredField("fMerger");
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error accessing document merger", e);
        }
        catch (NoSuchFieldException e) {
            CollaboratorUI.log("Error accessing document merger", e);
        }
        if (mergerField != null) {
            mergerField.setAccessible(true);
        }
        MERGER_FIELD = mergerField;
        Method handleSelectionChangedMethod = null;
        try {
            handleSelectionChangedMethod = TextMergeViewer.class.getDeclaredMethod("handleSelectionChanged", MergeSourceViewer.class);
        }
        catch (SecurityException e) {
            CollaboratorUI.log("Error accessing handleSelectionChanged(...) method", e);
        }
        catch (NoSuchMethodException e) {
            CollaboratorUI.log("Error accessing handleSelectionChanged(...) method", e);
        }
        if (handleSelectionChangedMethod != null) {
            handleSelectionChangedMethod.setAccessible(true);
        }
        HANDLE_SELECTION_CHANGED_METHOD = handleSelectionChangedMethod;
    }

    private static final class AnnotationListener
    implements ITextInputListener {
        private final ICompareModel compareModel;
        private final ModifiableAnnotationModel annotationModel;
        private IConversationProviderListener listener;

        private AnnotationListener(ICompareModel compareModel, ModifiableAnnotationModel annotationModel) {
            this.compareModel = compareModel;
            this.annotationModel = annotationModel;
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            this.annotationModel.removeAllAnnotations();
        }

        public void inputDocumentChanged(IDocument oldInput, final IDocument newInput) {
            if (this.listener != null) {
                this.compareModel.getReviewFile().removeConversationProviderListener(this.listener);
            }
            if (newInput == null) {
                return;
            }
            this.listener = new ConversationProviderAdapter(){

                public void conversationsAdded(IConversationProvider conversationProvider, ArrayList<? extends IConversation> newConversations) {
                    for (IConversation iConversation : newConversations) {
                        int position;
                        ILocator locator = compareModel.getLocator(iConversation);
                        if (locator.getType() != LocatorType.LINE) continue;
                        int lineNumber = ((LineLocator)locator).getLineNumber();
                        --lineNumber;
                        try {
                            position = newInput.getLineInformation(lineNumber).getOffset();
                        }
                        catch (BadLocationException e) {
                            CollaboratorUI.log("Bad document location: " + lineNumber, e);
                            continue;
                        }
                        final ConversationAnnotation annotation = new ConversationAnnotation(locator, iConversation);
                        annotationModel.addAnnotation(annotation, new Position(position));
                        iConversation.addConversationListener((IConversationListener)new ReviewConversationAdapter(){

                            public void defectsDeleted(IConversation conversation, ArrayList<? extends IDefect> deletedDefects) {
                                this.conversationChanged();
                            }

                            public void defectsAdded(IConversation conversation, ArrayList<? extends IDefect> newDefects) {
                                this.conversationChanged();
                            }

                            public void commentsAdded(IConversation conversation, ArrayList<? extends IComment> newComments) {
                                this.conversationChanged();
                            }

                            private void conversationChanged() {
                                annotationModel.modifyAnnotation(annotation, true);
                            }
                        });
                    }
                }
            };
            ConversationProviderAdapter.init((IConversationProvider)this.compareModel.getReviewFile(), (IConversationProviderListener)this.listener);
            this.compareModel.getReviewFile().addConversationProviderListener(this.listener);
        }
    }

    private static final class ModifiableAnnotationModel
    extends AnnotationModel {
        private ModifiableAnnotationModel() {
        }

        public void modifyAnnotation(Annotation annotation, boolean fireModelChanged) {
            super.modifyAnnotation(annotation, fireModelChanged);
        }
    }
}

