/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.materials;

import com.google.common.collect.Iterables;
import com.smartbear.ccollab.datamodel.client.IConversationSummary;
import com.smartbear.ccollab.datamodel.client.IReviewParticipant;
import com.smartbear.ccollab.datamodel.client.UserThreadState;
import com.smartbear.ccollab.datamodel.client.listener.IConversationSummaryListener;
import com.smartbear.ccollab.datamodel.client.listener.IConversationSummaryStateListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ConversationSummaryAdapter;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.Constants;
import com.smartbear.jface.LabelProviderChangedEvent2;
import com.smartbear.jface.TableLabelProvider2;
import org.eclipse.swt.graphics.Image;

class ConversationSummaryLabelProvider
extends TableLabelProvider2<IConversationSummary> {
    private final IConversationSummaryListener convoListener = new ConversationSummaryAdapter(){

        private void labelChanged(IConversationSummary convo) {
            if (ConversationSummaryLabelProvider.this.isDisposed()) {
                convo.removeConversationSummaryListener((IConversationSummaryListener)this);
                return;
            }
            ConversationSummaryLabelProvider.this.fireLabelChanged(convo);
        }

        public void unreadStateChanged(IConversationSummary conversation, boolean isUnread) {
            this.labelChanged(conversation);
        }

        public void stateChanged(IConversationSummary conversation, UserThreadState state) {
            this.labelChanged(conversation);
        }
    };
    private final IConversationSummaryStateListener convoStateListener = new IConversationSummaryStateListener(){

        public void stateChanged(IConversationSummary conversation, IReviewParticipant participant, UserThreadState state) {
            if (ConversationSummaryLabelProvider.this.isDisposed()) {
                conversation.removeConversationSummaryStateListener(participant, (IConversationSummaryStateListener)this);
                return;
            }
            ConversationSummaryLabelProvider.this.fireLabelChanged(conversation);
        }
    };

    ConversationSummaryLabelProvider() {
    }

    private void fireLabelChanged(IConversationSummary convo) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent2<IConversationSummary>(this, convo));
    }

    @Override
    public String getColumnText(IConversationSummary convo, int columnIndex) {
        if (columnIndex == 0) {
            return convo.getLocator().toString();
        }
        return "";
    }

    @Override
    public Image getColumnImage(IConversationSummary convo, int columnIndex) {
        String imageKey;
        convo.addConversationSummaryListener(this.convoListener);
        if (columnIndex == 0) {
            imageKey = convo.isUnread() ? "IMG_COMMENT_UNREAD" : "IMG_COMMENT";
        } else {
            int participantIndex = columnIndex - 1;
            IReviewParticipant participant = (IReviewParticipant)Iterables.get((Iterable)convo.getFile().getChangelist().getScmMaterials().getReviewSummary().getParticipants(), (int)participantIndex);
            if (participant.getUser() == null) {
                return null;
            }
            convo.addConversationSummaryStateListener(participant, this.convoStateListener);
            UserThreadState state = convo.getState(participant);
            imageKey = Constants.getImageKey(state);
        }
        return CollaboratorUI.getImage(imageKey);
    }
}

