/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.materials;

import com.google.common.collect.Maps;
import com.smartbear.ccollab.datamodel.client.IConversationSummary;
import com.smartbear.ccollab.datamodel.client.IReviewParticipant;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IReviewSummaryChangelist;
import com.smartbear.ccollab.datamodel.client.IScmMaterials;
import com.smartbear.ccollab.datamodel.client.ScmConsolidationMethod;
import com.smartbear.ccollab.datamodel.client.impl.DMReviewParticipant;
import com.smartbear.collaborator.jobs.ReviewRefreshJob;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.review.materials.ConversationSummaryLabelProvider;
import com.smartbear.collaborator.ui.review.materials.ConversationSummaryViewerComparator;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryChangelistContentProvider;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryChangelistLabelProvider;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryChangelistViewerComparator;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFile;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFileContentProvider;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFileLabelProvider;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFolder;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFolderContentProvider;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFolderLabelProvider;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFolderViewerComparator;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryMaterialsContentProvider;
import com.smartbear.collaborator.ui.review.materials.ScmMaterialsActionProvider;
import com.smartbear.collaborator.ui.review.materials.ScmMaterialsContentProvider;
import com.smartbear.collaborator.ui.review.materials.ScmMaterialsLabelProvider;
import com.smartbear.collaborator.ui.review.materials.ToolBarPopupMenuAction;
import com.smartbear.collaborator.ui.util.CommandOpenListener;
import com.smartbear.collections.PathTree;
import com.smartbear.jface.MultiActionProvider;
import com.smartbear.jface.MultiContentProvider;
import com.smartbear.jface.MultiLabelProvider;
import com.smartbear.jface.MultiOpenListener;
import com.smartbear.jface.MultiViewerComparator;
import com.smartbear.jface.TreeViewer2;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IServiceLocator;

public class MaterialsWidget
extends Composite {
    public static final String MENU_ID = "com.smartbear.collaborator.ui.editors.ReviewEditor.materials";
    private final TreeViewer2<IReviewSummary, Object> commonViewer;

    public MaterialsWidget(Composite parent, int style, IToolBarManager toolBarManager, IReviewSummary reviewSummary, ReviewRefreshJob refreshJob, IWorkbenchPartSite site) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.commonViewer = TreeViewer2.create(this, 67586);
        Tree tree = this.commonViewer.getControl();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        TreeColumn column = new TreeColumn(tree, 0);
        column.setMoveable(false);
        column.setText("Materials");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 1, true));
        for (IReviewParticipant participant : reviewSummary.getParticipants()) {
            if (participant.getUser() == null) continue;
            TreeColumn column2 = new TreeColumn(tree, 0x1000000);
            column2.setMoveable(false);
            column2.setText(participant.getUser().getInitials());
            column2.pack();
            int idealSize = column2.getWidth();
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(idealSize, false));
        }
        tree.setLayout((Layout)layout);
        MaterialsWidget.setChildrenStyle((Viewer)this.commonViewer.getInner(), PathTree.ChildrenStyle.COMPRESSED_TREE);
        MultiLabelProvider labelProvider = new MultiLabelProvider();
        labelProvider.set(IScmMaterials.class, new ScmMaterialsLabelProvider());
        labelProvider.set(IReviewSummaryChangelist.class, new ReviewSummaryChangelistLabelProvider());
        labelProvider.set(ReviewSummaryFolder.class, new ReviewSummaryFolderLabelProvider());
        labelProvider.set(ReviewSummaryFile.class, new ReviewSummaryFileLabelProvider());
        labelProvider.set(IConversationSummary.class, new ConversationSummaryLabelProvider());
        this.commonViewer.setLabelProvider(labelProvider);
        MultiViewerComparator viewerComparator = new MultiViewerComparator();
        viewerComparator.set(IReviewSummaryChangelist.class, new ReviewSummaryChangelistViewerComparator());
        ReviewSummaryFolderViewerComparator folderOrFileViewerComparator = new ReviewSummaryFolderViewerComparator();
        viewerComparator.set(ReviewSummaryFolder.class, folderOrFileViewerComparator);
        viewerComparator.set(ReviewSummaryFile.class, folderOrFileViewerComparator);
        viewerComparator.set(IConversationSummary.class, new ConversationSummaryViewerComparator());
        this.commonViewer.setComparator(viewerComparator);
        MultiContentProvider<IReviewSummary> contentProvider = new MultiContentProvider<IReviewSummary>();
        contentProvider.setRoot(new ReviewSummaryMaterialsContentProvider());
        contentProvider.add(IScmMaterials.class, new ScmMaterialsContentProvider());
        contentProvider.add(IReviewSummaryChangelist.class, new ReviewSummaryChangelistContentProvider());
        contentProvider.add(ReviewSummaryFolder.class, new ReviewSummaryFolderContentProvider());
        contentProvider.add(ReviewSummaryFile.class, new ReviewSummaryFileContentProvider());
        this.commonViewer.setContentProvider(contentProvider);
        MultiActionProvider contextMenuProvider = new MultiActionProvider();
        contextMenuProvider.add(IScmMaterials.class, new ScmMaterialsActionProvider(this.commonViewer, refreshJob));
        MenuManager menuManager = this.commonViewer.setContextMenuProvider(contextMenuProvider);
        site.registerContextMenu(MENU_ID, menuManager, (ISelectionProvider)this.commonViewer.getInner());
        MultiOpenListener openListener = new MultiOpenListener();
        openListener.set(ReviewSummaryFile.class, new CommandOpenListener((IServiceLocator)site, "com.smartbear.collaborator.ui.commands.OpenReviewFile"));
        openListener.set(IConversationSummary.class, new CommandOpenListener((IServiceLocator)site, "com.smartbear.collaborator.ui.commands.OpenReviewFile"));
        this.commonViewer.addOpenListener(openListener);
        HashMap participants = reviewSummary.getParticipantsMap();
        HashMap newParticipants = Maps.newHashMap();
        for (Map.Entry el : participants.entrySet()) {
            DMReviewParticipant participant = (DMReviewParticipant)el.getValue();
            if (participant.getUser() == null) continue;
            newParticipants.put((Integer)el.getKey(), participant);
        }
        reviewSummary.setParticipants(newParticipants);
        this.commonViewer.setInput(reviewSummary);
        this.commonViewer.getInner().expandAll();
        this.initActions(toolBarManager);
    }

    private void initActions(IToolBarManager toolBarManager) {
        ToolBarPopupMenuAction childrenStyleAction = new ToolBarPopupMenuAction("View", CollaboratorUI.getImageDescriptor("IMG_CHILDREN_STYLE"));
        for (PathTree.ChildrenStyle childrenStyle : PathTree.ChildrenStyle.values()) {
            childrenStyleAction.addPopupMenuItem((IAction)new ToggleChildrenStyleAction(childrenStyle));
        }
        toolBarManager.add((IAction)childrenStyleAction);
        toolBarManager.add((IAction)new Action("Expand All", CollaboratorUI.getImageDescriptor("IMG_EXPAND_ALL")){

            public void run() {
                MaterialsWidget.this.commonViewer.getInner().expandAll();
            }
        });
        toolBarManager.add((IAction)new Action("Collapse All", CollaboratorUI.getImageDescriptor("IMG_COLLAPSE_ALL")){

            public void run() {
                MaterialsWidget.this.commonViewer.getInner().collapseAll();
            }
        });
        toolBarManager.update(false);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.commonViewer.getInner();
    }

    private static Map<IScmMaterials, ScmConsolidationMethod> getConsolidationMethods(Viewer viewer) {
        WeakHashMap map = (WeakHashMap)viewer.getData(ScmConsolidationMethod.class.getName());
        if (map == null) {
            map = new WeakHashMap();
            viewer.setData(ScmConsolidationMethod.class.getName(), map);
        }
        return map;
    }

    static ScmConsolidationMethod getConsolidationMethod(Viewer viewer, IScmMaterials scmMaterials) {
        ScmConsolidationMethod consolidationMethod = MaterialsWidget.getConsolidationMethods(viewer).get(scmMaterials);
        if (consolidationMethod == null) {
            consolidationMethod = scmMaterials.getDefaultConsolidationMethod();
        }
        return consolidationMethod;
    }

    static void setConsolidationMethod(Viewer viewer, IScmMaterials scmMaterials, ScmConsolidationMethod consolidationMethod) {
        MaterialsWidget.getConsolidationMethods(viewer).put(scmMaterials, consolidationMethod);
    }

    static PathTree.ChildrenStyle getChildrenStyle(Viewer viewer) {
        return (PathTree.ChildrenStyle)viewer.getData(PathTree.ChildrenStyle.class.getName());
    }

    static void setChildrenStyle(Viewer viewer, PathTree.ChildrenStyle childrenStyle) {
        viewer.setData(PathTree.ChildrenStyle.class.getName(), (Object)childrenStyle);
    }

    private class ToggleChildrenStyleAction
    extends Action {
        private final PathTree.ChildrenStyle childrenStyle;

        public ToggleChildrenStyleAction(PathTree.ChildrenStyle childrenStyle) {
            super(childrenStyle.displayName, 8);
            this.childrenStyle = childrenStyle;
            this.setChecked(MaterialsWidget.getChildrenStyle((Viewer)MaterialsWidget.this.commonViewer.getInner()) == childrenStyle);
        }

        public void run() {
            if (this.isChecked()) {
                MaterialsWidget.setChildrenStyle((Viewer)MaterialsWidget.this.commonViewer.getInner(), this.childrenStyle);
                MaterialsWidget.this.commonViewer.refresh(true);
                MaterialsWidget.this.commonViewer.getInner().expandAll();
            }
        }
    }
}

