/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.materials;

import com.smartbear.ccollab.datamodel.client.FileSource;
import com.smartbear.ccollab.datamodel.client.IReviewSummary;
import com.smartbear.ccollab.datamodel.client.IReviewSummaryChangelist;
import com.smartbear.ccollab.datamodel.client.IReviewSummaryFile;
import com.smartbear.ccollab.datamodel.client.IScmMaterials;
import com.smartbear.ccollab.datamodel.client.listener.IReviewSummaryChangelistListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewSummaryChangelistAdapter;
import com.smartbear.collaborator.ui.review.materials.MaterialsWidget;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFolder;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFolderContentProvider;
import com.smartbear.collections.PathTree;
import com.smartbear.jface.InteriorTreeContentProvider2;
import com.smartbear.util.SmartBearUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;

class ReviewSummaryChangelistContentProvider
extends InteriorTreeContentProvider2<IReviewSummary, IReviewSummaryChangelist, Object> {
    private static final char SEPARATOR = '/';
    private IReviewSummaryChangelistListener listener = new ReviewSummaryChangelistAdapter(){

        public void filesAdded(IReviewSummaryChangelist changelist, ArrayList<? extends IReviewSummaryFile> addedFiles) {
            this.filesChanged(changelist);
        }

        public void filesDeleted(IReviewSummaryChangelist changelist, ArrayList<? extends IReviewSummaryFile> deletedFiles) {
            this.filesChanged(changelist);
        }

        private void filesChanged(IReviewSummaryChangelist changelist) {
            ReviewSummaryChangelistContentProvider.this.getViewer().refresh(changelist, true);
            ((AbstractTreeViewer)ReviewSummaryChangelistContentProvider.this.getViewer().getInner()).expandToLevel((Object)changelist, -1);
        }
    };

    ReviewSummaryChangelistContentProvider() {
    }

    private PathTree.ChildrenStyle getChildrenStyle() {
        return MaterialsWidget.getChildrenStyle((Viewer)this.getViewer().getInner());
    }

    @Override
    public Collection<? extends Object> getChildren(IReviewSummaryChangelist changelist) {
        Map compressedChildren;
        PathTree tree = new PathTree(null);
        ArrayList files = changelist.getFiles();
        for (IReviewSummaryFile file : files) {
            if (file.getFileSource() == FileSource.URL || file.getFileSource() == FileSource.SIMULINK) {
                tree.addUri(file.getPath(), (Object)file);
                continue;
            }
            tree.addPath(file.getPath(), (Object)file);
        }
        List<Object> children = null;
        if (this.getChildrenStyle() == PathTree.ChildrenStyle.FLAT && files.size() > 1 && (compressedChildren = tree.getChildren(PathTree.ChildrenStyle.COMPRESSED_TREE, '/')).size() == 1) {
            Map.Entry compressedChild = (Map.Entry)SmartBearUtils.getFirstObject(compressedChildren.entrySet());
            children = Collections.singletonList(new ReviewSummaryFolder((String)compressedChild.getKey(), (PathTree<IReviewSummaryFile>)((PathTree)compressedChild.getValue())));
        }
        if (children == null) {
            children = ReviewSummaryFolderContentProvider.getChildren((PathTree<IReviewSummaryFile>)tree, this.getChildrenStyle());
        }
        changelist.addChangelistListener(this.listener);
        return children;
    }

    @Override
    public boolean hasChildren(IReviewSummaryChangelist element) {
        return true;
    }

    @Override
    protected void doInputChanged(IReviewSummary oldInput, IReviewSummary newInput) {
        if (oldInput != null) {
            for (IScmMaterials materials : oldInput.getMaterials()) {
                for (IReviewSummaryChangelist changelist : materials.getChangelists()) {
                    changelist.removeChangelistListener(this.listener);
                }
            }
        }
    }
}

