/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.materials;

import com.smartbear.ccollab.datamodel.client.ChangeType;
import com.smartbear.ccollab.datamodel.client.FileSource;
import com.smartbear.ccollab.datamodel.client.IReviewSummaryFile;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFile;
import com.smartbear.jface.LabelProvider2;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;

class ReviewSummaryFileLabelProvider
extends LabelProvider2<ReviewSummaryFile> {
    private final LocalResourceManager imageManager = new LocalResourceManager(JFaceResources.getResources());

    ReviewSummaryFileLabelProvider() {
    }

    @Override
    public String getText(ReviewSummaryFile fileNode) {
        Object text = fileNode.getName();
        IReviewSummaryFile file = fileNode.getFile();
        if (file.getFileSource() == FileSource.SIMULINK) {
            text = (String)text + "\t\t (This file was uploaded as a Simulink archive, please use web version of Collaborator for review)";
        }
        return text;
    }

    @Override
    public Image getImage(ReviewSummaryFile fileNode) {
        ImageDescriptor decorationDesc;
        ImageDescriptor imageDesc;
        IReviewSummaryFile file = fileNode.getFile();
        if (file.getFileSource() == FileSource.URL || file.getFileSource() == FileSource.SIMULINK) {
            ICommandImageService imageService = (ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class);
            imageDesc = imageService.getImageDescriptor("org.eclipse.ui.browser.openBrowser");
        } else {
            imageDesc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(FilenameUtils.getName((String)file.getPath()));
        }
        Image image = this.imageManager.createImage(imageDesc);
        String decorationKey = (String)file.getChangeType().accept((ChangeType.IChangeTypeVisitor)new ChangeType.IChangeTypeVisitor<String>(){

            public String visitUploaded() {
                return null;
            }

            public String visitUnknown() {
                return null;
            }

            public String visitReverted() {
                return "IMG_REVERTED_OVERLAY";
            }

            public String visitReviewed() {
                return null;
            }

            public String visitModified() {
                return null;
            }

            public String visitIntegrated() {
                return null;
            }

            public String visitDeleted() {
                return "IMG_DELETED_OVERLAY";
            }

            public String visitExcluded() {
                return "IMG_EXCLUDED_OVERLAY";
            }

            public String visitBranched() {
                return null;
            }

            public String visitAdded() {
                return "IMG_ADDED_OVERLAY";
            }

            public String visitIncluded() {
                return "IMG_INCLUDED_OVERLAY";
            }

            public String visitAddedDirectory() {
                return null;
            }

            public String visitIncludedDirectoryOnly() {
                return null;
            }

            public String visitIncludedDirectory() {
                return null;
            }

            public String visitExcludedDirectory() {
                return null;
            }
        });
        ImageDescriptor imageDescriptor = decorationDesc = decorationKey == null ? null : CollaboratorUI.getImageDescriptor(decorationKey);
        if (decorationDesc != null) {
            image = new DecorationOverlayIcon(image, decorationDesc, 3).createImage();
        }
        return image;
    }

    @Override
    public void dispose() {
        this.imageManager.dispose();
        super.dispose();
    }
}

