/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.review.materials;

import com.google.common.collect.Lists;
import com.smartbear.ccollab.datamodel.client.IScmMaterials;
import com.smartbear.ccollab.datamodel.client.ScmConsolidationMethod;
import com.smartbear.collaborator.jobs.ReviewRefreshJob;
import com.smartbear.collaborator.ui.review.materials.MaterialsWidget;
import com.smartbear.jface.IActionProvider;
import com.smartbear.jface.TreeViewer2;
import com.smartbear.util.SmartBearUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;

class ScmMaterialsActionProvider
implements IActionProvider<IScmMaterials> {
    private final TreeViewer2<?, ?> viewer;
    private final ReviewRefreshJob refreshJob;

    public ScmMaterialsActionProvider(TreeViewer2<?, ?> viewer, ReviewRefreshJob refreshJob) {
        this.viewer = viewer;
        this.refreshJob = refreshJob;
    }

    @Override
    public List<? extends IAction> getActions(List<IScmMaterials> elements) {
        IScmMaterials scmMaterials = (IScmMaterials)SmartBearUtils.getFirstObject(elements);
        ArrayList actions = Lists.newArrayListWithCapacity((int)ScmConsolidationMethod.values().length);
        for (ScmConsolidationMethod consolidationMethod : ScmConsolidationMethod.values()) {
            actions.add(new ToggleScmConsolidationMethodAction(consolidationMethod, (AbstractTreeViewer)this.viewer.getInner(), scmMaterials));
        }
        return actions;
    }

    private class ToggleScmConsolidationMethodAction
    extends Action {
        private final ScmConsolidationMethod consolidationMethod;
        private final AbstractTreeViewer viewer;
        private final IScmMaterials scmMaterials;

        public ToggleScmConsolidationMethodAction(ScmConsolidationMethod consolidationMethod, AbstractTreeViewer viewer, IScmMaterials scmMaterials) {
            super(consolidationMethod.getDescription(), 8);
            this.consolidationMethod = consolidationMethod;
            this.viewer = viewer;
            this.scmMaterials = scmMaterials;
            this.setChecked(MaterialsWidget.getConsolidationMethod((Viewer)viewer, scmMaterials) == consolidationMethod);
        }

        public void run() {
            if (this.isChecked() && MaterialsWidget.getConsolidationMethod((Viewer)this.viewer, this.scmMaterials) != this.consolidationMethod) {
                MaterialsWidget.setConsolidationMethod((Viewer)this.viewer, this.scmMaterials, this.consolidationMethod);
                ScmMaterialsActionProvider.this.refreshJob.setConsolidationMethodAndRefresh(this.scmMaterials, this.consolidationMethod);
            }
        }
    }
}

