/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.ssl;

import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ssl.X509CertificateBlock;
import com.smartbear.collaborator.ui.ssl.X509CertificateViewer;
import java.security.cert.X509Certificate;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class X509CertificateDialog
extends MessageDialogWithToggle {
    static final String PRE_MESSAGE = "The SSL certificates sent by the server could not be validated:";
    static final String POST_MESSAGE = "It is possible, though unlikely, that someone may be trying to intercept your communication with this service.  If you have questions about the validity of the certificate, please check with your administrator.\n\nWould you like to accept this certificate chain?";
    private X509Certificate[] chain;

    public X509CertificateDialog(X509Certificate[] chain, String message) {
        super(CollaboratorUI.getShell(), "Confirm SSL Certificate", null, "The SSL certificates sent by the server could not be validated:\n\n" + message + "\n\nIt is possible, though unlikely, that someone may be trying to intercept your communication with this service.  If you have questions about the validity of the certificate, please check with your administrator.\n\nWould you like to accept this certificate chain?", 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, "Don't ask again for this certificate", true);
        this.chain = chain;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createCustomArea(Composite parent) {
        X509CertificateBlock block = new X509CertificateBlock(parent, 0);
        block.setLayoutData(new GridData(4, 4, true, true));
        X509CertificateViewer viewer = new X509CertificateViewer(block);
        viewer.setInput(this.chain);
        return block;
    }
}

