/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.util;

import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.util.commons.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.services.IServiceLocator;

public class CommandActionDelegate
extends ActionDelegate
implements IViewActionDelegate {
    private final String commandId;
    private final Map<String, Object> params;
    private IViewPart view;
    private ISelection rawSelection;

    public CommandActionDelegate(String commandId) {
        this(commandId, Collections.emptyMap());
    }

    public CommandActionDelegate(String commandId, Map<String, Object> params) {
        this.commandId = commandId;
        this.params = params;
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    public void init(final IAction action) {
        super.init(action);
        IWorkbenchPartSite viewSite = this.view == null ? null : this.view.getSite();
        IServiceLocator serviceLocator = (IServiceLocator)ObjectUtils.defaultIfNull((Object)viewSite, (Object)PlatformUI.getWorkbench());
        ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
        if (commandService == null) {
            CollaboratorUI.log("Could not locate ICommandService from " + serviceLocator, null);
            return;
        }
        Command command = commandService.getCommand(this.commandId);
        if (command == null) {
            return;
        }
        command.addCommandListener(new ICommandListener(){

            public void commandChanged(CommandEvent commandEvent) {
                if (commandEvent.isEnabledChanged()) {
                    action.setEnabled(commandEvent.getCommand().isEnabled());
                }
            }
        });
        action.setEnabled(command.isEnabled());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.rawSelection = selection;
    }

    public void run(IAction action) {
        IWorkbenchPartSite viewSite = this.view == null ? null : this.view.getSite();
        IServiceLocator serviceLocator = (IServiceLocator)ObjectUtils.defaultIfNull((Object)viewSite, (Object)PlatformUI.getWorkbench());
        List selection = !(this.rawSelection instanceof IStructuredSelection) ? Collections.emptyList() : ((IStructuredSelection)this.rawSelection).toList();
        try {
            PlatformUIUtils.executeCommand(serviceLocator, this.commandId, this.params, selection);
        }
        catch (ExecutionException e) {
            Shell shell = viewSite != null ? viewSite.getShell() : CollaboratorUI.getShell();
            CollaboratorUI.openError(shell, "Error invoking command '" + this.commandId + "'", e, false, true);
        }
    }
}

