/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.util;

import com.smartbear.ccollab.datamodel.client.FileSource;
import com.smartbear.ccollab.datamodel.client.IReviewSummaryFile;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.review.materials.ReviewSummaryFile;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.jface.IOpenListener2;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.services.IServiceLocator;

public class CommandOpenListener<E>
implements IOpenListener2<E> {
    private final IServiceLocator serviceLocator;
    private final String commandId;
    private final Map<String, Object> commandParams;

    public CommandOpenListener(IServiceLocator serviceLocator, String commandId) {
        this(serviceLocator, commandId, Collections.emptyMap());
    }

    public CommandOpenListener(IServiceLocator serviceLocator, String commandId, Map<String, Object> commandParams) {
        this.serviceLocator = serviceLocator;
        this.commandId = commandId;
        this.commandParams = commandParams;
    }

    @Override
    public void open(List<E> elements) {
        try {
            boolean isSimulink = false;
            for (E e : elements) {
                ReviewSummaryFile reviewSummaryFile;
                IReviewSummaryFile file;
                if (!(e instanceof ReviewSummaryFile) || (file = (reviewSummaryFile = (ReviewSummaryFile)e).getFile()).getFileSource() != FileSource.SIMULINK) continue;
                isSimulink = true;
                break;
            }
            if (isSimulink) {
                CollaboratorUI.openWarning(CollaboratorUI.getShell(), "This file was uploaded as a Simulink archive, please use web version of Collaborator for review");
            } else {
                PlatformUIUtils.executeCommand(this.serviceLocator, this.commandId, this.commandParams, elements);
            }
        }
        catch (ExecutionException e) {
            CollaboratorUI.log("Error opening " + elements, e);
        }
    }
}

