/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.util;

import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.util.ISimpleSaveDialogSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileLock;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.dialogs.DialogSettings;

public class FileDialogSettings
extends DialogSettings
implements ISimpleSaveDialogSettings {
    private final File file;

    public FileDialogSettings(File file) {
        super(null);
        this.file = file;
        try {
            if (file.exists()) {
                this.load(file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            CollaboratorUI.log("Error loading dialog settings: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        block6: {
            FileOutputStream stream = null;
            OutputStreamWriter writer = null;
            try {
                stream = new FileOutputStream(this.file);
                FileLock lock = stream.getChannel().tryLock();
                if (lock == null) {
                    throw new IOException(this.file + " is locked by another process");
                }
                writer = new OutputStreamWriter(stream);
                this.save(writer);
                IOUtils.closeQuietly((Writer)writer);
            }
            catch (IOException e) {
                CollaboratorUI.log("Error saving dialog settings: " + e.getMessage(), e);
                break block6;
            }
            finally {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly((OutputStream)stream);
            }
            IOUtils.closeQuietly((OutputStream)stream);
        }
    }
}

