/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLParser {
    private Matcher mTag;
    private Matcher mLink;
    private Pattern pTag = Pattern.compile("(?i)<a([^>]+)>(.+?)</a>");
    private Pattern pLink = Pattern.compile("\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))");
    private static final String HTML_TAG_PATTERN = "(?i)<a([^>]+)>(.+?)</a>";
    private static final String HTML_HREF_TAG_PATTERN = "\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))";

    public ArrayList<HTMLLinkElement> extractHTMLLinks(String sourceHtml) {
        ArrayList<HTMLLinkElement> elements = new ArrayList<HTMLLinkElement>();
        this.mTag = this.pTag.matcher(sourceHtml);
        while (this.mTag.find()) {
            String href = this.mTag.group(1);
            String linkElem = this.mTag.group(2);
            this.mLink = this.pLink.matcher(href);
            while (this.mLink.find()) {
                String link = this.mLink.group(1);
                HTMLLinkElement htmlLinkElement = new HTMLLinkElement();
                htmlLinkElement.setLinkAddress(link);
                htmlLinkElement.setLinkElement(linkElem);
                elements.add(htmlLinkElement);
                System.out.println(htmlLinkElement);
            }
        }
        return elements;
    }

    public class HTMLLinkElement {
        String linkElement;
        String linkAddress;

        public String getLinkAddress() {
            return this.linkAddress;
        }

        public void setLinkAddress(String linkElement) {
            this.linkAddress = this.replaceInvalidChar(linkElement);
        }

        public String getLinkElement() {
            return this.linkElement;
        }

        public void setLinkElement(String linkAddress) {
            this.linkElement = linkAddress;
        }

        private String replaceInvalidChar(String linkElement) {
            linkElement = linkElement.replaceAll("'", "");
            linkElement = linkElement.replaceAll("\"", "");
            return linkElement;
        }
    }
}

