/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.util;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class PersistentSizeApplicationWindow
extends ApplicationWindow {
    private static final String WINDOW_ORIGIN_X = "WINDOW_X_ORIGIN";
    private static final String WINDOW_ORIGIN_Y = "WINDOW_Y_ORIGIN";
    private static final String WINDOW_WIDTH = "WINDOW_WIDTH";
    private static final String WINDOW_HEIGHT = "WINDOW_HEIGHT";
    private static final String WINDOW_FONT_DATA = "WINDOW_FONT_NAME";
    public static final int WINDOW_DEFAULT_BOUNDS = -1;
    public static final int WINDOW_PERSISTLOCATION = 1;
    public static final int WINDOW_PERSISTSIZE = 2;

    public PersistentSizeApplicationWindow(Shell shell) {
        super(shell);
    }

    protected void initializeBounds() {
        Point size = this.getInitialSize();
        Point location = this.getInitialLocation(size);
        this.getShell().setBounds(this.getConstrainedShellBounds(new Rectangle(location.x, location.y, size.x, size.y)));
    }

    public boolean close() {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.saveWindowBounds(this.getShell());
        }
        boolean returnValue = super.close();
        return returnValue;
    }

    protected IDialogSettings getWindowBoundsSettings() {
        return null;
    }

    protected int getWindowBoundsStrategy() {
        return 3;
    }

    private void saveWindowBounds(Shell shell) {
        IDialogSettings settings = this.getWindowBoundsSettings();
        if (settings != null) {
            int strategy;
            Point shellLocation = shell.getLocation();
            Point shellSize = shell.getSize();
            Shell parent = this.getParentShell();
            if (parent != null) {
                Point parentLocation = parent.getLocation();
                shellLocation.x -= parentLocation.x;
                shellLocation.y -= parentLocation.y;
            }
            if (((strategy = this.getWindowBoundsStrategy()) & 1) != 0) {
                settings.put(WINDOW_ORIGIN_X, shellLocation.x);
                settings.put(WINDOW_ORIGIN_Y, shellLocation.y);
            }
            if ((strategy & 2) != 0) {
                settings.put(WINDOW_WIDTH, shellSize.x);
                settings.put(WINDOW_HEIGHT, shellSize.y);
                FontData[] fontDatas = JFaceResources.getDialogFont().getFontData();
                if (fontDatas.length > 0) {
                    settings.put(WINDOW_FONT_DATA, fontDatas[0].toString());
                }
            }
        }
    }

    protected Point getInitialSize() {
        IDialogSettings settings;
        Point result = super.getInitialSize();
        if ((this.getWindowBoundsStrategy() & 2) != 0 && (settings = this.getWindowBoundsSettings()) != null) {
            FontData[] fontDatas;
            boolean useStoredBounds = true;
            String previousWindowFontData = settings.get(WINDOW_FONT_DATA);
            if (previousWindowFontData != null && previousWindowFontData.length() > 0 && (fontDatas = JFaceResources.getDialogFont().getFontData()).length > 0) {
                String currentWindowFontData = fontDatas[0].toString();
                useStoredBounds = currentWindowFontData.equalsIgnoreCase(previousWindowFontData);
            }
            if (useStoredBounds) {
                try {
                    int height;
                    int width = settings.getInt(WINDOW_WIDTH);
                    if (width != -1) {
                        result.x = width;
                    }
                    if ((height = settings.getInt(WINDOW_HEIGHT)) != -1) {
                        result.y = height;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        IDialogSettings settings;
        Point result = super.getInitialLocation(initialSize);
        if ((this.getWindowBoundsStrategy() & 1) != 0 && (settings = this.getWindowBoundsSettings()) != null) {
            try {
                int x = settings.getInt(WINDOW_ORIGIN_X);
                int y = settings.getInt(WINDOW_ORIGIN_Y);
                result = new Point(x, y);
                Shell parent = this.getParentShell();
                if (parent != null) {
                    Point parentLocation = parent.getLocation();
                    result.x += parentLocation.x;
                    result.y += parentLocation.y;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

