/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.swt.SwtUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public enum PlatformUIUtils {

    private static final Parameterization[] EMPTY_PARAMETERIZATION_ARRAY = new Parameterization[0];

    public static boolean executeCommand(IServiceLocator serviceLocator, String commandId, Map<String, Object> params, List<?> selection) throws ExecutionException {
        ParameterizedCommand parameterizedCommand;
        IHandlerService handlerService;
        block16: {
            ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
            if (commandService == null) {
                CollaboratorUI.log("Could not locate ICommandService from " + serviceLocator, null);
                return false;
            }
            handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
            if (handlerService == null) {
                CollaboratorUI.log("Could not locate IHandlerService from " + serviceLocator, null);
                return false;
            }
            Command command = commandService.getCommand(commandId);
            if (command == null) {
                CollaboratorUI.log("Could not locate '" + commandId + "' command from " + commandService, null);
                return false;
            }
            try {
                if (params == null || params.isEmpty()) {
                    parameterizedCommand = new ParameterizedCommand(command, null);
                    break block16;
                }
                ArrayList paramList = Lists.newArrayListWithCapacity((int)params.size());
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    IParameter parameter = null;
                    parameter = command.getParameter(key);
                    Preconditions.checkArgument((parameter != null ? 1 : 0) != 0, (String)"Command %s does not have a parameter %s", (Object)commandId, (Object)key);
                    ParameterType parameterType = command.getParameterType(key);
                    if (parameterType == null) {
                        paramList.add(new Parameterization(parameter, (String)entry.getValue()));
                        continue;
                    }
                    AbstractParameterValueConverter valueConverter = parameterType.getValueConverter();
                    if (valueConverter != null) {
                        String val;
                        try {
                            val = valueConverter.convertToString(entry.getValue());
                        }
                        catch (ParameterValueConversionException e) {
                            throw new IllegalArgumentException("Error converting parameter '" + key + "' value '" + entry.getValue() + "'", e);
                        }
                        paramList.add(new Parameterization(parameter, val));
                        continue;
                    }
                    paramList.add(new Parameterization(parameter, (String)entry.getValue()));
                }
                parameterizedCommand = new ParameterizedCommand(command, paramList.toArray(EMPTY_PARAMETERIZATION_ARRAY));
            }
            catch (NotDefinedException e) {
                CollaboratorUI.log("Command " + commandId + " not defined", e);
                return false;
            }
        }
        IEvaluationContext context = handlerService.getCurrentState();
        if (selection != null) {
            StructuredSelection iSelection = new StructuredSelection(selection);
            context = new EvaluationContext(context, selection);
            context.addVariable("selection", (Object)iSelection);
        }
        try {
            handlerService.executeCommandInContext(parameterizedCommand, null, context);
        }
        catch (NotDefinedException e) {
            CollaboratorUI.log("Command " + parameterizedCommand + " not defined", e);
            return false;
        }
        catch (NotEnabledException e) {
            CollaboratorUI.log("Command " + parameterizedCommand + " not enabled", e);
            return false;
        }
        catch (NotHandledException e) {
            CollaboratorUI.log("Command " + parameterizedCommand + " not handled", e);
            return false;
        }
        return true;
    }

    public static <T> T getSelection(ExecutionEvent event, Class<T> type) {
        if (event.getApplicationContext() instanceof IEvaluationContext) {
            return PlatformUIUtils.getSelection((IEvaluationContext)event.getApplicationContext(), type);
        }
        return null;
    }

    public static <T> T getSelection(IEvaluationContext context, Class<T> type) {
        T selection = null;
        ISelection swtSelection = null;
        swtSelection = PlatformUIUtils.getSelectionVariable(context, "activeMenuSelection");
        if (swtSelection != null) {
            selection = SwtUtils.getSelection(swtSelection, type);
        }
        if (selection != null) {
            return selection;
        }
        swtSelection = PlatformUIUtils.getSelectionVariable(context, "selection");
        if (swtSelection != null) {
            selection = SwtUtils.getSelection(swtSelection, type);
        }
        if (selection != null) {
            return selection;
        }
        swtSelection = PlatformUIUtils.getSelectionVariable(context, null);
        if (swtSelection != null) {
            selection = SwtUtils.getSelection(swtSelection, type);
        }
        return selection;
    }

    public static <T> List<T> getMultiSelection(ExecutionEvent event, Class<T> type) {
        if (event.getApplicationContext() instanceof IEvaluationContext) {
            return PlatformUIUtils.getMultiSelection((IEvaluationContext)event.getApplicationContext(), type);
        }
        return Collections.emptyList();
    }

    public static <T> List<T> getMultiSelection(IEvaluationContext context, Class<T> type) {
        List selection = Collections.emptyList();
        ISelection swtSelection = null;
        swtSelection = PlatformUIUtils.getSelectionVariable(context, "activeMenuSelection");
        if (swtSelection != null) {
            selection = SwtUtils.getMultiSelection(swtSelection, type);
        }
        if (!selection.isEmpty()) {
            return selection;
        }
        swtSelection = PlatformUIUtils.getSelectionVariable(context, "selection");
        if (swtSelection != null) {
            selection = SwtUtils.getMultiSelection(swtSelection, type);
        }
        if (!selection.isEmpty()) {
            return selection;
        }
        swtSelection = PlatformUIUtils.getSelectionVariable(context, null);
        if (swtSelection != null) {
            selection = SwtUtils.getMultiSelection(swtSelection, type);
        }
        return selection;
    }

    private static ISelection getSelectionVariable(IEvaluationContext context, String name) {
        Object var = name == null ? context.getDefaultVariable() : context.getVariable(name);
        return var instanceof ISelection ? (ISelection)var : null;
    }
}

