/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.util;

import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.RegexStyledTextDecorator;
import com.smartbear.text.HyperlinkTextDecorator;
import java.util.Collections;
import java.util.regex.MatchResult;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;

public class URLStyledTextDecorator
extends RegexStyledTextDecorator {
    private final IWorkbenchSite site;

    public URLStyledTextDecorator(IWorkbenchSite site) {
        super(HyperlinkTextDecorator.EMAIL_OR_URL_PATTERN);
        this.site = site;
    }

    @Override
    protected void decorate(StyledText text, MatchResult matchResult) {
        final String url = matchResult.group(1);
        final String email = matchResult.group(2);
        SwtUtils.addLink(text, matchResult.start(), matchResult.end(), url == null ? "Send email" : url, new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUIUtils.executeCommand((IServiceLocator)URLStyledTextDecorator.this.site, "org.eclipse.ui.browser.openBrowser", Collections.singletonMap("url", url == null ? "mailto:" + email : url), null);
                }
                catch (ExecutionException e) {
                    CollaboratorUI.log("Error launching browser", e);
                }
            }
        });
    }
}

