/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.views;

import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import com.smartbear.collaborator.PlatformUtils;
import com.smartbear.util.SmartBearUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public abstract class AbstractContextView
extends PageBookView {
    private final IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            IWorkbenchPart part = AbstractContextView.this.getCurrentContributingPart();
            if (part != null) {
                AbstractContextView.this.reconsiderPart(part);
            }
        }
    };
    final String defaultPageMessage;

    protected static <T> T getAdapter(IWorkbenchPart part, Class<T> adapter) {
        if (part == null) {
            return null;
        }
        Object t = PlatformUtils.CastStrategy.ADAPT.cast((Object)part, adapter);
        if (t == null && part instanceof IEditorPart) {
            t = PlatformUtils.CastStrategy.ADAPT.cast((Object)((IEditorPart)part).getEditorInput(), adapter);
        }
        return (T)t;
    }

    public AbstractContextView(String defaultPageMessage) {
        this.defaultPageMessage = defaultPageMessage;
    }

    protected void reconsiderPart(IWorkbenchPart part) {
        boolean isImportant;
        PageBookView.PageRec pageRec = this.getPageRec(part);
        boolean wasImportant = pageRec != null && pageRec.page != this.getDefaultPage();
        if (wasImportant == (isImportant = this.isImportant(part))) {
            return;
        }
        this.partDeactivated(part);
        this.partClosed(part);
        this.partOpened(part);
        this.partActivated(part);
    }

    protected void resetPages() {
        IWorkbenchPart currentPart = this.getCurrentContributingPart();
        IWorkbenchPage workbenchPage = this.getSite().getPage();
        for (IWorkbenchPartReference partRef : Iterables.concat(Arrays.asList(workbenchPage.getViewReferences()), Arrays.asList(workbenchPage.getEditorReferences()))) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part == null) continue;
            this.partDeactivated(part);
            this.partClosed(part);
        }
        this.reconsiderPart(currentPart);
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part instanceof IPageChangeProvider) {
            ((IPageChangeProvider)part).addPageChangedListener(this.pageChangedListener);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        if (part instanceof IPageChangeProvider) {
            ((IPageChangeProvider)part).removePageChangedListener(this.pageChangedListener);
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage messagePage = new MessagePage();
        messagePage.setMessage(this.defaultPageMessage);
        this.initPage((IPageBookViewPage)messagePage);
        messagePage.createControl((Composite)book);
        return messagePage;
    }

    protected IWorkbenchPart getBootstrapPart() {
        final IWorkbenchPage page = this.getSite().getPage();
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        for (IWorkbenchPartReference partRef : (IWorkbenchPartReference[])ObjectArrays.concat((Object[])page.getViewReferences(), (Object[])page.getEditorReferences(), IWorkbenchPartReference.class)) {
            IWorkbenchPart part = partRef.getPart(false);
            if (!this.isImportant(part)) continue;
            parts.add(part);
        }
        Collections.sort(parts, new Comparator<IWorkbenchPart>(){

            @Override
            public int compare(IWorkbenchPart p1, IWorkbenchPart p2) {
                if (p1.equals(page.getActivePart())) {
                    return 1;
                }
                if (p2.equals(page.getActivePart())) {
                    return -1;
                }
                if (p1 instanceof IEditorPart && p2 instanceof IViewPart) {
                    return 1;
                }
                if (p1 instanceof IViewPart && p2 instanceof IEditorPart) {
                    return -1;
                }
                return 0;
            }
        });
        return (IWorkbenchPart)SmartBearUtils.getFirstObject(parts);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        Page page = this.internalDoCreatePage(part);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected abstract Page internalDoCreatePage(IWorkbenchPart var1);

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        if (pageRecord.page != null) {
            pageRecord.page.dispose();
        }
    }

    public static void broadcastReconsiderPart(IWorkbenchPart part) {
        for (IViewReference viewReference : part.getSite().getPage().getViewReferences()) {
            IViewPart viewPart = viewReference.getView(false);
            if (!(viewPart instanceof AbstractContextView)) continue;
            ((AbstractContextView)viewPart).reconsiderPart(part);
        }
    }
}

