/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.views;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.smartbear.ccollab.client.commands.Command;
import com.smartbear.ccollab.client.commands.admin.review.AbstractVersionLocatableCommand;
import com.smartbear.ccollab.client.commands.admin.review.defect.CommandDefectEdit;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IComment;
import com.smartbear.ccollab.datamodel.client.IConversation;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.IDefect;
import com.smartbear.ccollab.datamodel.client.ILocator;
import com.smartbear.ccollab.datamodel.client.IVersion;
import com.smartbear.ccollab.datamodel.client.IVersionLocatable;
import com.smartbear.ccollab.datamodel.client.LabelLocator;
import com.smartbear.ccollab.datamodel.client.OverallLocator;
import com.smartbear.ccollab.datamodel.client.listener.IConversationListener;
import com.smartbear.ccollab.datamodel.client.listener.IConversationProviderListener;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ConversationProviderAdapter;
import com.smartbear.ccollab.datamodel.client.listener.adapter.ReviewConversationAdapter;
import com.smartbear.collaborator.ui.ActivityListener;
import com.smartbear.collaborator.ui.ICommandRunner;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.ReviewCommandRunner;
import com.smartbear.collaborator.ui.review.ConversationContextAdapter;
import com.smartbear.collaborator.ui.review.ConversationWidget;
import com.smartbear.collaborator.ui.review.DefectLogWidget;
import com.smartbear.collaborator.ui.review.IConversationContext;
import com.smartbear.collaborator.ui.review.IConversationContextListener;
import com.smartbear.collaborator.ui.util.URLStyledTextDecorator;
import com.smartbear.swt.SwtUtils;
import com.smartbear.swt.text.CompositeStyledTextDecorator;
import com.smartbear.swt.text.IStyledTextDecorator;
import com.smartbear.util.ComparisonMode;
import com.smartbear.util.ListenerList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

class ConversationsPage
extends Page {
    private final Set<ConversationWidget.Style> style;
    private final IClientSystemGlobals clientSystemGlobals;
    private final IConversationProvider conversationProvider;
    private final IVersion newConversationsVersion;
    private final IConversationContext convoContext;
    private final ActivityListener activityListener;
    private final ISaveableListener saveableListener;
    private IStyledTextDecorator userTextDecorator;
    private FormToolkit formToolkit;
    protected ScrolledForm form;
    private final IConversationContextListener convoContextListener = new ConversationContextAdapter(){

        @Override
        public void locatorSelected(ILocator locator) {
            ConversationsPage.this.setCurrentLocator(locator, true);
        }

        @Override
        public void whyNotAllowedToStartNewConversationChanged(String whyNotAllowedToStartNewConversation) {
            if (ConversationsPage.this.newLocatorSection == null) {
                return;
            }
            ConversationsPage.this.newLocatorSection.updateEnablement();
            ConversationsPage.this.newLocatorSection.getSection().setToolTipText(StringUtils.defaultIfEmpty((String)whyNotAllowedToStartNewConversation, null));
            ConversationsPage.this.newLocatorSection.getSection().layout();
        }
    };
    private final IConversationProviderListener conversationProviderListener = new ConversationProviderAdapter(){

        public void conversationsAdded(IConversationProvider conversationProvider, ArrayList<? extends IConversation> newConversations) {
            if (ConversationsPage.this.form == null || ConversationsPage.this.locatorMap == null) {
                return;
            }
            ArrayList<IConversation> importantConversations = new ArrayList<IConversation>(newConversations.size());
            for (IConversation iConversation : newConversations) {
                if (ConversationsPage.this.isImportant(iConversation)) {
                    importantConversations.add(iConversation);
                }
                iConversation.addConversationListener(ConversationsPage.this.conversationListener);
            }
            if (importantConversations.isEmpty()) {
                return;
            }
            ConversationsPage.this.form.setLayoutDeferred(true);
            for (IConversation iConversation : importantConversations) {
                ConversationsPage.this.createConversationSection(iConversation);
            }
            ConversationsPage.this.form.setLayoutDeferred(false);
            ConversationsPage.this.form.reflow(true);
        }
    };
    private final IConversationListener conversationListener = new ReviewConversationAdapter(){

        public void commentsAdded(IConversation conversation, ArrayList<? extends IComment> newComments) {
            this.conversationChanged(conversation);
        }

        public void defectsAdded(IConversation conversation, ArrayList<? extends IDefect> newDefects) {
            this.conversationChanged(conversation);
        }

        public void defectsDeleted(IConversation conversation, ArrayList<? extends IDefect> deletedDefects) {
            this.conversationChanged(conversation);
        }

        protected void conversationChanged(IConversation conversation) {
            ILocator locator = ConversationsPage.this.convoContext.getLocator((IVersionLocatable)conversation);
            if (OverallLocator.INSTANCE.equals((Object)locator)) {
                return;
            }
            if (ConversationsPage.this.locatorMap.containsKey(locator) && !ConversationsPage.this.isImportant(conversation)) {
                if (ConversationsPage.this.locatorMap.containsKey(locator)) {
                    ConversationSection convoSection = (ConversationSection)ConversationsPage.this.locatorMap.remove(locator);
                    convoSection.getSection().dispose();
                }
                ConversationsPage.this.form.reflow(true);
            } else if (!ConversationsPage.this.locatorMap.containsKey(locator) && ConversationsPage.this.isImportant(conversation)) {
                ConversationsPage.this.createConversationSection(conversation);
                ConversationsPage.this.form.reflow(true);
            }
        }
    };
    private final ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList(ComparisonMode.IDENTITY);
    private final ISelectionProvider selectionProvider = new ISelectionProvider(){

        public void setSelection(ISelection selection) {
            ILocator locator = SwtUtils.getSelection(selection, ILocator.class);
            if (locator != null) {
                ConversationsPage.this.setCurrentLocator(locator, true);
            }
        }

        public ISelection getSelection() {
            return ConversationsPage.this.createSelection(ConversationsPage.this.currentLocator);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            ConversationsPage.this.selectionChangedListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            ConversationsPage.this.selectionChangedListeners.remove((Object)listener);
        }
    };
    private SortedMap<ILocator, ConversationSection> locatorMap;
    private ILocator currentLocator;
    private ConversationSection currentLocatorSection;
    private NewConversationSection newLocatorSection;

    public ConversationsPage(Set<ConversationWidget.Style> style, IClientSystemGlobals clientSystemGlobals, IConversationProvider conversationProvider, IVersion newConversationsVersion, IConversationContext convoContext, ActivityListener activityListener, ISaveableListener saveableListener) {
        this.style = style;
        this.clientSystemGlobals = clientSystemGlobals;
        this.conversationProvider = conversationProvider;
        this.newConversationsVersion = newConversationsVersion;
        this.convoContext = convoContext;
        this.activityListener = activityListener;
        this.saveableListener = saveableListener;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        if (pageSite == null) {
            return;
        }
        this.userTextDecorator = CompositeStyledTextDecorator.of(this.convoContext.getUserTextDecorator(), new URLStyledTextDecorator((IWorkbenchSite)this.getSite()));
        pageSite.setSelectionProvider(this.selectionProvider);
    }

    IConversationProvider getConversationProvider() {
        return this.conversationProvider;
    }

    IClientSystemGlobals getClientSystemGlobals() {
        return this.clientSystemGlobals;
    }

    private ICommandRunner createCommandRunner(final IConversation convo, final ILocator locator) {
        final int reviewId = this.conversationProvider.getId();
        return new ICommandRunner(){

            @Override
            public void run(Command command, boolean async) {
                if (command instanceof AbstractVersionLocatableCommand) {
                    AbstractVersionLocatableCommand convoCommand = (AbstractVersionLocatableCommand)command;
                    if (convo != null && !convo.getComments().isEmpty()) {
                        convoCommand.setConversationId(Integer.valueOf(((IComment)convo.getComments().get(0)).getId()));
                    } else {
                        if (ConversationsPage.this.newConversationsVersion != null) {
                            convoCommand.setVersionId(Integer.valueOf(ConversationsPage.this.newConversationsVersion.getId()));
                        }
                        convoCommand.internalSetLocator(locator == null ? ConversationsPage.this.newLocatorSection.getLocator() : locator);
                    }
                }
                new ReviewCommandRunner(reviewId, (IWorkbenchSite)ConversationsPage.this.getSite()).run(command, async);
            }
        };
    }

    private ISelection createSelection(ILocator locator) {
        ArrayList selection = Lists.newArrayListWithExpectedSize((int)3);
        selection.add(this.conversationProvider);
        selection.add(this.convoContext);
        if (locator != null) {
            selection.add(locator);
        }
        return new StructuredSelection((List)selection);
    }

    public void createControl(Composite parent) {
        this.formToolkit = new FormToolkit(parent.getDisplay());
        this.form = this.formToolkit.createScrolledForm(parent);
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
        this.form.getHorizontalBar().addSelectionListener((SelectionListener)this.activityListener);
        this.form.getVerticalBar().addSelectionListener((SelectionListener)this.activityListener);
        this.locatorMap = new TreeMap<ILocator, ConversationSection>();
        IConversation conversation = this.conversationProvider.getOverallConversation();
        this.createConversationSection(conversation);
        conversation.addConversationListener(this.conversationListener);
        for (IConversation conversation2 : this.conversationProvider.getConversations()) {
            if (this.isImportant(conversation2)) {
                this.createConversationSection(conversation2);
            }
            conversation2.addConversationListener(this.conversationListener);
        }
        if (this.conversationProvider.allowsNewConversations()) {
            this.newLocatorSection = (NewConversationSection)this.createConversationSection(null);
        }
        this.convoContext.addConversationContextListener(this.convoContextListener);
        ConversationContextAdapter.init(this.convoContext, this.convoContextListener);
        this.conversationProvider.addConversationProviderListener(this.conversationProviderListener);
    }

    private ConversationSection createConversationSection(IConversation conversation) {
        ILocator locator = conversation == null ? null : this.convoContext.getLocator((IVersionLocatable)conversation);
        Section section = this.formToolkit.createSection(this.form.getBody(), 8512);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setBackgroundMode(1);
        ConversationWidget conversationControl = new ConversationWidget((Composite)section, SwtUtils.BASE_COMPOSITE_STYLE, this.style, this.formToolkit, this.clientSystemGlobals, this.conversationProvider, conversation, this.conversationProvider.getDefectCustomFields(), this.createCommandRunner(conversation, locator), this.userTextDecorator, this.saveableListener);
        SwtUtils.recursiveAdapt(this.formToolkit, (Control)conversationControl, false, false, true, true);
        section.setClient((Control)conversationControl);
        final ConversationSection convoSection = conversation != null ? new ConversationSection(section, conversationControl) : new NewConversationSection(section, conversationControl);
        convoSection.setLocator(locator);
        if (convoSection.getLocator() != null) {
            Section afterSection;
            this.locatorMap.put(convoSection.getLocator(), convoSection);
            SortedMap<ILocator, ConversationSection> afterMap = this.locatorMap.headMap(convoSection.getLocator());
            ConversationSection afterSectionPart = afterMap.isEmpty() ? null : (ConversationSection)afterMap.get(afterMap.lastKey());
            Section section2 = afterSection = afterSectionPart == null ? null : afterSectionPart.getSection();
            if (afterSection != null) {
                convoSection.getSection().moveBelow((Control)afterSection);
            } else {
                convoSection.getSection().moveAbove(null);
            }
            if (Objects.equal((Object)this.currentLocator, (Object)convoSection.getLocator())) {
                this.form.showControl((Control)convoSection.getSection());
                if (this.newLocatorSection != null && SwtUtils.isFocusAncestor((Composite)this.newLocatorSection.getSection())) {
                    this.newLocatorSection.setLocator(null);
                    convoSection.getConvoWidget().setFocus();
                }
            }
            SwtUtils.recursiveAddFocusListener((Control)convoSection.getSection(), (FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ILocator selectedLocator = convoSection.getLocator();
                    if (convoSection == ConversationsPage.this.newLocatorSection) {
                        selectedLocator = null;
                    }
                    ISelection selection = ConversationsPage.this.createSelection(selectedLocator);
                    for (ISelectionChangedListener listener : ConversationsPage.this.selectionChangedListeners.getListeners()) {
                        listener.selectionChanged(new SelectionChangedEvent(ConversationsPage.this.selectionProvider, selection));
                    }
                }
            });
        }
        SwtUtils.recursiveAddFocusListener((Control)convoSection.getSection(), (FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ConversationsPage.this.currentLocator = convoSection.getLocator();
                ConversationsPage.this.currentLocatorSection = convoSection;
            }
        });
        return convoSection;
    }

    protected boolean isImportant(IConversation conversation) {
        return ConversationWidget.Style.isImportant(this.style, conversation);
    }

    public void dispose() {
        this.convoContext.removeConversationContextListener(this.convoContextListener);
        for (IConversation convo : Iterables.concat(Collections.singleton(this.conversationProvider.getOverallConversation()), (Iterable)this.conversationProvider.getConversations())) {
            convo.removeConversationListener(this.conversationListener);
        }
        this.conversationProvider.removeConversationProviderListener(this.conversationProviderListener);
        super.dispose();
        if (this.formToolkit != null) {
            this.formToolkit.dispose();
        }
    }

    public Control getControl() {
        return this.form;
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private void setCurrentLocator(ILocator locator, boolean show) {
        this.currentLocator = locator;
        if (this.locatorMap != null) {
            if (locator != null && this.locatorMap.containsKey(locator)) {
                this.currentLocatorSection = (ConversationSection)this.locatorMap.get(locator);
                if (this.newLocatorSection != null) {
                    this.newLocatorSection.setLocator(null);
                }
            } else if (this.conversationProvider.allowsNewConversations()) {
                this.newLocatorSection.setLocator(locator);
                this.currentLocatorSection = this.newLocatorSection;
            } else {
                throw new RuntimeException("No control for locator " + locator);
            }
            this.currentLocatorSection.getConvoWidget().setFocus();
            if (show) {
                this.form.showControl((Control)this.currentLocatorSection.getSection());
            }
        }
    }

    public List<CommandDefectEdit> getSaveCommands() {
        ArrayList saveCommands = Lists.newArrayList();
        for (ConversationSection convoSection : this.locatorMap.values()) {
            ConversationWidget conversationWidget = convoSection.getConvoWidget();
            DefectLogWidget defectLog = conversationWidget.getDefectLog();
            if (defectLog == null || !defectLog.isDirty()) continue;
            saveCommands.addAll(defectLog.getSaveCommands());
        }
        return saveCommands;
    }

    public List<String> getSaveErrorMessages() {
        ArrayList saveErrorMessages = Lists.newArrayList();
        for (ConversationSection convoSection : this.locatorMap.values()) {
            ConversationWidget conversationWidget = convoSection.getConvoWidget();
            DefectLogWidget defectLog = conversationWidget.getDefectLog();
            if (defectLog == null || !defectLog.isDirty()) continue;
            saveErrorMessages.addAll(defectLog.getSaveErrorMessages());
        }
        return saveErrorMessages;
    }

    public boolean isDirty() {
        for (ConversationSection convoSection : this.locatorMap.values()) {
            ConversationWidget conversationWidget = convoSection.getConvoWidget();
            DefectLogWidget defectLog = conversationWidget.getDefectLog();
            if (defectLog == null || !defectLog.isDirty()) continue;
            return true;
        }
        return false;
    }

    private class NewConversationSection
    extends ConversationSection {
        private final StyledText labelLocatorText;

        protected NewConversationSection(final Section section, ConversationWidget convoWidget) {
            super(section, convoWidget);
            if (ConversationsPage.this.convoContext.allowsLabelLocators()) {
                this.labelLocatorText = new StyledText((Composite)section, 2052);
                this.labelLocatorText.setBackground(section.getDisplay().getSystemColor(25));
                this.labelLocatorText.setToolTipText("To start a new chat thread, click in Compare Editor or enter a label here");
                section.setTextClient((Control)this.labelLocatorText);
                section.setText("New Conversation on ");
                this.labelLocatorText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        NewConversationSection.this.updateEnablement();
                        section.layout();
                        SwtUtils.resizeVerticalIfNecessary((Control)section);
                    }
                });
            } else {
                this.labelLocatorText = null;
            }
        }

        @Override
        public ILocator getLocator() {
            ILocator baseLocator = super.getLocator();
            if (this.labelLocatorText == null) {
                return baseLocator;
            }
            String label = this.labelLocatorText.getText();
            if (baseLocator != null && label.equals(baseLocator.toString())) {
                return baseLocator;
            }
            if (StringUtils.isBlank((String)this.labelLocatorText.getText())) {
                return null;
            }
            return new LabelLocator(this.labelLocatorText.getText());
        }

        @Override
        public void setLocator(ILocator locator) {
            this.locator = locator;
            if (this.labelLocatorText == null) {
                this.getSection().setText(SwtUtils.escapeMnemonics("New Conversation" + (String)(locator == null ? "" : " on " + locator.toString())));
            } else {
                this.labelLocatorText.setText(locator == null ? "" : locator.toString());
            }
            this.updateEnablement();
            this.getSection().layout();
        }

        public void updateEnablement() {
            boolean newConvoAllowed = StringUtils.isBlank((String)ConversationsPage.this.convoContext.getWhyNotAllowedToStartNewConversation());
            this.getConvoWidget().setEditable(this.getLocator() != null && newConvoAllowed);
            if (this.labelLocatorText != null) {
                this.labelLocatorText.setEnabled(newConvoAllowed);
            }
        }
    }

    private static class ConversationSection {
        private final Section section;
        private final ConversationWidget convoWidget;
        protected ILocator locator;

        public ConversationSection(Section section, ConversationWidget convoWidget) {
            this.section = section;
            this.convoWidget = convoWidget;
        }

        public final Section getSection() {
            return this.section;
        }

        public final ConversationWidget getConvoWidget() {
            return this.convoWidget;
        }

        public ILocator getLocator() {
            return this.locator;
        }

        public void setLocator(ILocator locator) {
            this.locator = locator;
            this.section.setText(SwtUtils.escapeMnemonics(locator.toString()));
        }
    }
}

