/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.views;

import com.google.common.base.Objects;
import com.smartbear.ccollab.datamodel.client.IClientSystemGlobals;
import com.smartbear.ccollab.datamodel.client.IConversationProvider;
import com.smartbear.ccollab.datamodel.client.IVersion;
import com.smartbear.collaborator.jobs.ClientModelRefreshJob;
import com.smartbear.collaborator.ui.ActivityListener;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ISaveableListener;
import com.smartbear.collaborator.ui.review.ConversationWidget;
import com.smartbear.collaborator.ui.review.IConversationContext;
import com.smartbear.collaborator.ui.views.AbstractContextView;
import com.smartbear.collaborator.ui.views.ConversationsPage;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.SmartBearUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBookView;

public class ConversationsView
extends AbstractContextView
implements ISaveablePart {
    private static final String DEFAULT_SHOW_DEFECTS_LABEL = "Show &Defects";
    public static final String ID = "com.smartbear.collaborator.ui.views.ConversationsView";
    private final Set<ConversationWidget.Style> conversationStyle = EnumSet.allOf(ConversationWidget.Style.class);
    private final ToggleStyleAction showCommentsAction = new ToggleStyleAction("Show &Comments", CollaboratorUI.getImageDescriptor("IMG_COMMENT"), ConversationWidget.Style.COMMENTS);
    private final ToggleStyleAction showDefectsAction = new ToggleStyleAction("Show &Defects", CollaboratorUI.getImageDescriptor("IMG_DEFECT_FIXED"), ConversationWidget.Style.DEFECTS);
    private final IAction newViewAction = new Action("&New Conversations View"){

        public void run() {
            try {
                ConversationsView.this.getSite().getPage().showView(ConversationsView.ID, Long.toString(System.currentTimeMillis()), 1);
            }
            catch (PartInitException e) {
                CollaboratorUI.openError(ConversationsView.this.getSite().getShell(), "Error opening New Conversation View", e, false, false);
            }
        }
    };
    private final ISaveableListener saveableListener = new ISaveableListener(){

        @Override
        public void dirtyStateMayHaveChanged() {
            ConversationsView.this.firePropertyChange(257);
        }
    };

    public ConversationsView() {
        super("Select a file or Review to see Conversations");
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IActionBars actionBars = site.getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)this.showCommentsAction);
        toolBarManager.add((IAction)this.showDefectsAction);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add(this.newViewAction);
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return ConversationsView.getAdapter(part, IClientSystemGlobals.class) != null && ConversationsView.getAdapter(part, IConversationProvider.class) != null && ConversationsView.getAdapter(part, IConversationContext.class) != null && ConversationsView.getAdapter(part, ActivityListener.class) != null;
    }

    @Override
    protected Page internalDoCreatePage(IWorkbenchPart part) {
        IClientSystemGlobals clientSystemGlobals = ConversationsView.getAdapter(part, IClientSystemGlobals.class);
        IConversationProvider conversationProvider = ConversationsView.getAdapter(part, IConversationProvider.class);
        IVersion newConversationsVersion = ConversationsView.getAdapter(part, IVersion.class);
        IConversationContext convoContext = ConversationsView.getAdapter(part, IConversationContext.class);
        ActivityListener activityListener = ConversationsView.getAdapter(part, ActivityListener.class);
        return new ConversationsPage(this.conversationStyle, clientSystemGlobals, conversationProvider, newConversationsVersion, convoContext, activityListener, this.saveableListener);
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        if (pageRec.page instanceof ConversationsPage) {
            IClientSystemGlobals clientSystemGlobals = ((ConversationsPage)pageRec.page).getClientSystemGlobals();
            this.showDefectsAction.setText("Show " + SwtUtils.escapeMnemonics(WordUtils.capitalize((String)clientSystemGlobals.getDefectsLabelPlural())));
        } else {
            this.showDefectsAction.setText(DEFAULT_SHOW_DEFECTS_LABEL);
        }
    }

    @Override
    public void partActivated(IWorkbenchPart part) {
        IPage oldPage = this.getCurrentPage();
        super.partActivated(part);
        IPage newPage = this.getCurrentPage();
        if (!Objects.equal((Object)oldPage, (Object)newPage)) {
            this.saveableListener.dirtyStateMayHaveChanged();
        }
    }

    @Override
    public void partClosed(IWorkbenchPart part) {
        PageBookView.PageRec pageRec = this.getPageRec(part);
        if (pageRec != null && pageRec.page instanceof ConversationsPage && ((ConversationsPage)pageRec.page).isDirty()) {
            ConversationsPage page = (ConversationsPage)pageRec.page;
            IClientSystemGlobals clientSystemGlobals = page.getClientSystemGlobals();
            String defectsLabelPlural = clientSystemGlobals.getDefectsLabelPlural();
            if (page.getSaveErrorMessages().isEmpty() && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)("Save " + WordUtils.capitalize((String)defectsLabelPlural)), (String)("Save changes to " + defectsLabelPlural + " on " + page.getConversationProvider().getName() + "?"))) {
                CollaboratorUI.executeServerCommands(page.getSaveCommands(), (IWorkbenchSite)this.getSite(), false);
            }
        }
        super.partClosed(part);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        throw new RuntimeException("SaveAs not allowed");
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public boolean isDirty() {
        IPage page = this.getCurrentPage();
        if (page instanceof ConversationsPage) {
            return ((ConversationsPage)page).isDirty();
        }
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        IPage rawPage = this.getCurrentPage();
        if (!(rawPage instanceof ConversationsPage)) {
            return;
        }
        ConversationsPage page = (ConversationsPage)rawPage;
        if (!page.isDirty()) {
            return;
        }
        List<String> saveErrorMessages = page.getSaveErrorMessages();
        if (!saveErrorMessages.isEmpty()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Can not save", (String)((String)SmartBearUtils.getFirstObject(saveErrorMessages)));
            monitor.setCanceled(true);
            return;
        }
        boolean success = CollaboratorUI.executeServerCommands(page.getSaveCommands(), monitor);
        if (!success) {
            monitor.setCanceled(true);
        }
        for (Job job : Job.getJobManager().find(ClientModelRefreshJob.getReviewFamily((int)page.getConversationProvider().getId()))) {
            ((ClientModelRefreshJob)job).start();
        }
    }

    private class ToggleStyleAction
    extends Action {
        private final ConversationWidget.Style style;

        public ToggleStyleAction(String text, ImageDescriptor image, ConversationWidget.Style style) {
            super(text, 2);
            this.style = style;
            this.setImageDescriptor(image);
            this.setChecked(true);
        }

        public void run() {
            if (this.isChecked()) {
                ConversationsView.this.conversationStyle.add(this.style);
            } else {
                ConversationsView.this.conversationStyle.remove((Object)this.style);
            }
            ConversationsView.this.resetPages();
        }
    }
}

