/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.smartbear.ccollab.datamodel.DataModelUtils;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.json.interfaces.review.materials.request.LocalFilesRequest;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.json.utils.JsonUtils;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.changes.ChangedAndRevertedFilter;
import com.smartbear.collaborator.ui.changes.ChangedAndRevertedLabelDecorator;
import com.smartbear.collaborator.ui.changes.ChangesSelectionBlock;
import com.smartbear.collaborator.ui.wizards.AddToReviewWizard;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmLocalCheckout;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractFileChangesSelectionPage<R extends IAdaptable, C extends R, F extends R>
extends WizardPage
implements IChangesSelectionPage,
IAdapterFactory {
    private ChangedAndRevertedFilter scmFilter;
    private ChangedAndRevertedLabelDecorator scmDecorator;
    private ITreeContentProvider treeProvider;
    protected ChangesSelectionBlock block;
    private final Collection<? extends C> roots;
    private final Collection<? extends C> initialSelectionFolders;
    private final Collection<? extends F> initialSelectionFiles;
    private final Class<F> fileType;
    private Map<F, IScmLocalCheckout> modifiedFileToCheckout = Collections.emptyMap();
    private Map<F, IScmCommitInfo.State> modifiedFileToState = Collections.emptyMap();
    private Map<F, IScmLocalCheckout> revertedFileToCheckout = Collections.emptyMap();
    private Map<F, IScmCommitInfo.State> revertedFileToState = Collections.emptyMap();
    private ReviewInfo reviewInfoCache;

    public AbstractFileChangesSelectionPage(Iterable<? extends C> roots, Iterable<? extends C> initialSelectionFolders, Iterable<? extends F> initialSelectionFiles, Class<F> fileType) {
        super("changesPage", "Select Files", null);
        this.roots = Lists.newArrayList(roots);
        this.initialSelectionFolders = Lists.newArrayList(initialSelectionFolders);
        this.initialSelectionFiles = Lists.newArrayList(initialSelectionFiles);
        this.fileType = fileType;
        this.setDescription("Select files to add to the Review");
    }

    protected Collection<? extends C> getInitialSelectionFolders() {
        return this.initialSelectionFolders;
    }

    public Collection<? extends F> getInitialSelectionFiles() {
        return this.initialSelectionFiles;
    }

    private <E extends R> Iterable<E> filterInitialSelection(Iterable<E> resources) {
        Function toInFolderPredicate = new Function<C, Predicate<R>>(){

            public Predicate<R> apply(C initialSelectionFolder) {
                return new Predicate<R>((IAdaptable)initialSelectionFolder){
                    final /* synthetic */ IAdaptable val$initialSelectionFolder;
                    {
                        this.val$initialSelectionFolder = iAdaptable;
                    }

                    public boolean apply(R resource) {
                        return AbstractFileChangesSelectionPage.this.contains(this.val$initialSelectionFolder, resource);
                    }
                };
            }
        };
        return Iterables.filter(resources, (Predicate)Predicates.or((Iterable)Iterables.transform(this.initialSelectionFolders, (Function)toInFolderPredicate)));
    }

    protected abstract boolean contains(C var1, R var2);

    protected abstract Map<F, IScmLocalCheckout> getModifiedFiles(C var1, IProgressMonitor var2) throws ScmCommunicationException;

    private void initializeModifiedFiles() {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Calculating modified files", 100);
                    AbstractFileChangesSelectionPage.this.modifiedFileToCheckout = new HashMap();
                    IteratorWithProgress rootItr = IteratorWithProgress.getIterator(AbstractFileChangesSelectionPage.this.roots, (String)"Calculating modified files", (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    while (rootItr.hasNext()) {
                        try {
                            AbstractFileChangesSelectionPage.this.modifiedFileToCheckout.putAll(AbstractFileChangesSelectionPage.this.getModifiedFiles((IAdaptable)rootItr.next(), rootItr.getIterationProgressMonitor()));
                        }
                        catch (ScmCommunicationException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    AbstractFileChangesSelectionPage.this.modifiedFileToState = new HashMap();
                    IteratorWithProgress entryItr = IteratorWithProgress.getIterator(AbstractFileChangesSelectionPage.this.modifiedFileToCheckout.entrySet(), (String)"Calculating state of files", (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    while (entryItr.hasNext()) {
                        Map.Entry entry = (Map.Entry)entryItr.next();
                        try {
                            AbstractFileChangesSelectionPage.this.modifiedFileToState.put((IAdaptable)entry.getKey(), ((IScmLocalCheckout)entry.getValue()).getState(entryItr.getIterationProgressMonitor()));
                        }
                        catch (ScmCommunicationException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            Object errorMessage = "Error initalizing changed files.";
            if (targetException.getMessage().matches("git:\\s+fatal:\\s+bad\\s+revision\\s+'HEAD'")) {
                errorMessage = (String)errorMessage + " Git repo appears to be empty or in a detached HEAD state.";
            }
            CollaboratorUI.openError(this.getShell(), (String)errorMessage, targetException, false, true);
            this.setErrorMessage((String)errorMessage);
            this.setPageComplete(false);
        }
        catch (InterruptedException e) {
            CollaboratorUI.log("Interrupted initializing changed files", e);
        }
    }

    public void dispose() {
        super.dispose();
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this);
    }

    protected void resetFilters() {
        this.block.treeViewer.resetFilters();
        if (!this.block.showUnchangedFilesCheckBox.getSelection() && this.scmFilter != null) {
            this.block.treeViewer.addFilter(this.scmFilter);
        }
    }

    public void createControl(Composite parent) {
        this.block = new ChangesSelectionBlock(parent, 0);
        this.setControl((Control)this.block);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)this, this.fileType);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractFileChangesSelectionPage.this.initializeModifiedFiles();
                AbstractFileChangesSelectionPage.this.scmDecorator = new ChangedAndRevertedLabelDecorator(AbstractFileChangesSelectionPage.this.revertedFileToCheckout.values());
                AbstractFileChangesSelectionPage.this.block.treeViewer.setLabelProvider((IBaseLabelProvider)AbstractFileChangesSelectionPage.this.getLabelProvider(AbstractFileChangesSelectionPage.this.scmDecorator));
                AbstractFileChangesSelectionPage.this.block.treeViewer.setSorter(AbstractFileChangesSelectionPage.this.getSorter());
                AbstractFileChangesSelectionPage.this.treeProvider = AbstractFileChangesSelectionPage.this.getContentProvider(AbstractFileChangesSelectionPage.this.modifiedFileToCheckout.keySet());
                AbstractFileChangesSelectionPage.this.block.treeViewer.setContentProvider((IContentProvider)AbstractFileChangesSelectionPage.this.treeProvider);
                AbstractFileChangesSelectionPage.this.block.treeViewer.setInput(AbstractFileChangesSelectionPage.this.roots);
                AbstractFileChangesSelectionPage.this.scmFilter = new ChangedAndRevertedFilter((Collection<? extends IAdaptable>)Sets.union(AbstractFileChangesSelectionPage.this.modifiedFileToCheckout.keySet(), AbstractFileChangesSelectionPage.this.revertedFileToCheckout.keySet()), AbstractFileChangesSelectionPage.this.treeProvider);
                AbstractFileChangesSelectionPage.this.setCheckedAndReveal(AbstractFileChangesSelectionPage.this.modifiedFileToCheckout.keySet());
                SelectionAdapter filtersListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractFileChangesSelectionPage.this.resetFilters();
                        AbstractFileChangesSelectionPage.this.block.treeViewer.expandCheckedLeaves();
                    }
                };
                AbstractFileChangesSelectionPage.this.block.showUnchangedFilesCheckBox.addSelectionListener((SelectionListener)filtersListener);
            }
        });
    }

    protected abstract ILabelProvider getLabelProvider(ChangedAndRevertedLabelDecorator var1);

    protected abstract ViewerSorter getSorter();

    protected abstract ITreeContentProvider getContentProvider(Collection<F> var1);

    private void setCheckedAndReveal(Collection<F> scmFiles) {
        boolean showUnchangedFiles = scmFiles.isEmpty() ? true : !scmFiles.containsAll(this.initialSelectionFiles);
        this.block.showUnchangedFilesCheckBox.setSelection(showUnchangedFiles);
        this.resetFilters();
        this.block.treeViewer.setCheckedElements(Lists.newArrayList((Iterable)Iterables.concat(this.filterInitialSelection(scmFiles), this.initialSelectionFiles)).toArray());
        this.block.treeViewer.expandCheckedLeaves();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        try {
            this.initializeChecks();
        }
        catch (ScmCommunicationException e) {
            CollaboratorUI.openError(this.getShell(), "Error initializing checks", e, false, true);
        }
    }

    protected void initializeChecks() throws ScmCommunicationException {
        this.updateInitialSelectionFiles(this.getCheckedFiles());
        ReviewInfo reviewInfo = ((AddToReviewWizard)this.getWizard()).reviewPage.getReviewInfo();
        if (reviewInfo == null) {
            return;
        }
        if (!reviewInfo.equals(this.reviewInfoCache)) {
            this.resetRevertedFilesJson(reviewInfo);
            this.refreshRevertedFilter();
            this.setCheckedAndReveal(this.getModifiedAndRevertedFiles());
            this.reviewInfoCache = reviewInfo;
        }
    }

    protected void resetRevertedFilesJson(ReviewInfo reviewInfo) throws ScmCommunicationException {
        String hostGuid = PrefsHelper.getPrefs().getClientGuid();
        List reviewLocalPaths = null;
        try {
            JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
            CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
            LocalFilesRequest filesRequest = (LocalFilesRequest)JsonUtils.create(LocalFilesRequest.class);
            filesRequest.setReviewId(reviewInfo.getReviewId());
            filesRequest.setHostGuid(hostGuid);
            List paths = jsonApi.reviewApi().reviewMaterialsApi().getLocalFiles(reviewInfo.getReviewId().intValue(), hostGuid);
            reviewLocalPaths = DataModelUtils.getReviewLocalPaths((List)paths);
        }
        catch (CollabClientException e) {
            CollaboratorUI.openError(this.getShell(), "JSON protocol error in getLocalFiles", e, false, false);
        }
        final List previouslyModifiedFiles = reviewLocalPaths;
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    AbstractFileChangesSelectionPage.this.revertedFileToCheckout = new HashMap();
                    IteratorWithProgress rootItr = IteratorWithProgress.getIterator(AbstractFileChangesSelectionPage.this.roots, (String)"Calculating reverted files", (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    while (rootItr.hasNext()) {
                        try {
                            AbstractFileChangesSelectionPage.this.revertedFileToCheckout.putAll(AbstractFileChangesSelectionPage.this.getRevertedFiles((IAdaptable)rootItr.next(), AbstractFileChangesSelectionPage.this.modifiedFileToCheckout.values(), previouslyModifiedFiles, rootItr.getIterationProgressMonitor()));
                        }
                        catch (ScmCommunicationException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    AbstractFileChangesSelectionPage.this.revertedFileToState = new HashMap();
                    IteratorWithProgress entryItr = IteratorWithProgress.getIterator(AbstractFileChangesSelectionPage.this.revertedFileToCheckout.entrySet(), (String)"Calculating state of reverted files", (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    while (entryItr.hasNext()) {
                        Map.Entry entry = (Map.Entry)entryItr.next();
                        try {
                            AbstractFileChangesSelectionPage.this.revertedFileToState.put((IAdaptable)entry.getKey(), ((IScmLocalCheckout)entry.getValue()).getState(entryItr.getIterationProgressMonitor()));
                        }
                        catch (ScmCommunicationException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ScmCommunicationException) {
                throw (ScmCommunicationException)e.getTargetException();
            }
            CollaboratorUI.log("Could not get Reverted Files", e);
        }
        catch (InterruptedException e) {
            CollaboratorUI.log("Could not get Reverted Files", e);
        }
    }

    @Override
    public IScmChangeAdapter getSelectedChangesAdapter() throws ScmCommunicationException {
        Collection<F> files;
        if (this.isControlCreated()) {
            this.initializeChecks();
            files = this.getCheckedElements();
        } else {
            this.initializeModifiedFiles();
            ReviewInfo reviewInfo = ((AddToReviewWizard)this.getWizard()).reviewPage.getReviewInfo();
            if (reviewInfo != null) {
                this.resetRevertedFilesJson(reviewInfo);
            }
            files = this.getDefaultSelection(this.modifiedFileToCheckout.keySet(), this.revertedFileToCheckout.keySet());
        }
        HashSet modifiedAndRevertedCheckouts = new HashSet();
        modifiedAndRevertedCheckouts.addAll(Maps.filterKeys(this.modifiedFileToCheckout, (Predicate)Predicates.in(files)).values());
        files.removeAll(this.modifiedFileToCheckout.keySet());
        modifiedAndRevertedCheckouts.addAll(Maps.filterKeys(this.revertedFileToCheckout, (Predicate)Predicates.in(files)).values());
        files.removeAll(this.revertedFileToCheckout.keySet());
        return this.doGetSelectedChangesAdapter(modifiedAndRevertedCheckouts, files);
    }

    protected abstract IScmChangeAdapter doGetSelectedChangesAdapter(Collection<? extends IScmLocalCheckout> var1, Collection<? extends R> var2);

    private Collection<F> getDefaultSelection(Set<F> modifiedFiles, Set<F> revertedFiles) {
        HashSet<? extends F> defaultSelection = new HashSet<F>();
        Iterables.addAll(defaultSelection, this.filterInitialSelection(Iterables.concat(modifiedFiles, revertedFiles)));
        defaultSelection.addAll(this.initialSelectionFiles);
        return defaultSelection;
    }

    protected abstract Map<F, IScmLocalCheckout> getRevertedFiles(C var1, Collection<IScmLocalCheckout> var2, List<File> var3, IProgressMonitor var4) throws ScmCommunicationException;

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!this.fileType.isInstance(adaptableObject)) {
            return null;
        }
        IAdaptable file = (IAdaptable)adaptableObject;
        if (adapterType == IScmLocalCheckout.class) {
            if (this.modifiedFileToCheckout.containsKey(file)) {
                return this.modifiedFileToCheckout.get(file);
            }
            if (this.revertedFileToCheckout.containsKey(file)) {
                return this.revertedFileToCheckout.get(file);
            }
            return null;
        }
        if (adapterType == IScmCommitInfo.State.class) {
            if (this.modifiedFileToState.containsKey(file)) {
                return this.modifiedFileToState.get(file);
            }
            if (this.revertedFileToState.containsKey(file)) {
                return this.revertedFileToState.get(file);
            }
            return null;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IScmLocalCheckout.class, IScmCommitInfo.State.class};
    }

    private void refreshRevertedFilter() {
        this.scmFilter = new ChangedAndRevertedFilter((Collection<? extends IAdaptable>)Sets.union(this.modifiedFileToCheckout.keySet(), this.revertedFileToCheckout.keySet()), this.treeProvider);
        this.scmDecorator = new ChangedAndRevertedLabelDecorator(this.revertedFileToCheckout.values());
        this.block.treeViewer.refresh();
    }

    private Set<F> getModifiedAndRevertedFiles() {
        HashSet<F> scmFiles = new HashSet<F>(this.modifiedFileToCheckout.keySet());
        scmFiles.addAll(this.revertedFileToCheckout.keySet());
        this.removeUncheckedFiles(scmFiles);
        return scmFiles;
    }

    private Set<F> getCheckedFiles() {
        Object[] checkedLeaves = this.block.treeViewer.getCheckedLeaves();
        HashSet<IAdaptable> checkedFiles = new HashSet<IAdaptable>();
        for (Object checkedFile : checkedLeaves) {
            checkedFiles.add((IAdaptable)checkedFile);
        }
        return checkedFiles;
    }

    private Set<F> getCheckedElements() {
        Object[] typelessCheckedElements = this.block.treeViewer.getCheckedElements();
        HashSet<IAdaptable> checkedElements = new HashSet<IAdaptable>();
        for (Object typelessCheckedElement : typelessCheckedElements) {
            checkedElements.add((IAdaptable)typelessCheckedElement);
        }
        return checkedElements;
    }

    private void removeUncheckedFiles(Set<F> scmFiles) {
        Set<F> selectedFiles = this.getCheckedFiles();
        HashSet<IAdaptable> uncheckedFiles = new HashSet<IAdaptable>();
        for (IAdaptable scmFile : scmFiles) {
            if (selectedFiles.contains(scmFile)) continue;
            uncheckedFiles.add(scmFile);
        }
        scmFiles.removeAll(uncheckedFiles);
    }

    private void updateInitialSelectionFiles(Set initialFiles) {
        if (initialFiles != null && !initialFiles.isEmpty()) {
            this.initialSelectionFiles.clear();
            this.initialSelectionFiles.addAll(initialFiles);
        }
    }
}

