/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.jobs.AddToReviewJob;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.wizards.ConfirmationPage;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.collaborator.ui.wizards.ReviewPage;
import com.smartbear.collaborator.ui.wizards.SupportingDocumentsSelectionPage;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AddToReviewWizard
extends Wizard {
    private IJobChangeListener jobListener;
    public final ReviewPage reviewPage;
    protected IChangesSelectionPage changesPage;
    protected SupportingDocumentsSelectionPage supportingDocumentsPage;
    protected ConfirmationPage confirmationPage;

    public AddToReviewWizard(String titlePrefix, IChangesSelectionPage changesPage) {
        this.setWindowTitle(titlePrefix + " to Review");
        this.changesPage = changesPage;
        this.reviewPage = new ReviewPage();
        if (changesPage != null) {
            this.reviewPage.suggestReviewTitle(changesPage.getSuggestedNewReviewTitle());
        }
        this.setDefaultPageImageDescriptor(CollaboratorUI.getImageDescriptor("IMG_NEW_REVIEW_WIZARD"));
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(CollaboratorUI.getDialogSettings());
    }

    public void dispose() {
        super.dispose();
        CollaboratorUI.saveDialogSettings();
    }

    public void setJobListener(IJobChangeListener listener) {
        this.jobListener = listener;
    }

    public void addPages() {
        this.addChangesPage();
        this.addPage((IWizardPage)this.reviewPage);
        this.supportingDocumentsPage = new SupportingDocumentsSelectionPage();
        this.addPage((IWizardPage)this.supportingDocumentsPage);
        this.confirmationPage = new ConfirmationPage(this);
        this.addPage((IWizardPage)this.confirmationPage);
    }

    protected void addChangesPage() {
        this.addPage(this.changesPage);
    }

    public boolean performFinish() {
        IScmChangeAdapter selectedChangesAdapter;
        try {
            selectedChangesAdapter = this.changesPage.getSelectedChangesAdapter();
        }
        catch (ScmCommunicationException e) {
            CollaboratorUI.openError(this.getShell(), "Could not finish Add to Review Wizard", e, false, true);
            return false;
        }
        List<File> supportingDocuments = this.supportingDocumentsPage.getSupportingDocuments();
        if (selectedChangesAdapter.isEmpty() && supportingDocuments.isEmpty()) {
            boolean areYouSure;
            String reviewContentsLabel = selectedChangesAdapter.getDisplayLabel();
            boolean bl = areYouSure = new MessageDialog(this.getShell(), "Warning: No " + reviewContentsLabel + " Selected", null, "You have not selected any " + reviewContentsLabel + " to add to this Review.  Do you want to continue?", 4, new String[]{"Yes", "No"}, 1).open() == 0;
            if (!areYouSure) {
                return false;
            }
        }
        AddToReviewJob job = this.reviewPage.getReviewJob(selectedChangesAdapter, supportingDocuments);
        if (this.jobListener != null) {
            job.addJobChangeListener(this.jobListener);
        }
        job.schedule();
        return true;
    }
}

