/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.smartbear.beans.IScmOptions;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.collaborator.scm.ScmChangeAdapter;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AtomicChangesSelectionPage
extends WizardPage
implements IChangesSelectionPage {
    protected final String atomicChangesLabel;
    private IStructuredSelection defaultSelection = StructuredSelection.EMPTY;
    protected final IScmOptions options;
    protected StructuredViewer viewer;

    public AtomicChangesSelectionPage(String atomicChangesLabel, IScmOptions options) {
        super("AtomicChangesSelectionPage", "Select " + atomicChangesLabel, null);
        this.atomicChangesLabel = atomicChangesLabel;
        this.options = options;
        this.setDescription("Select " + atomicChangesLabel + " to add to the Review");
    }

    public void setDefaultSelection(IStructuredSelection selection) {
        Object object = this.defaultSelection = selection == null ? StructuredSelection.EMPTY : selection;
        if (this.isControlCreated() && !this.defaultSelection.isEmpty()) {
            this.viewer.setSelection((ISelection)this.defaultSelection);
        }
    }

    protected IStructuredSelection getDefaultSelection() {
        return this.defaultSelection;
    }

    protected IScmChangelist toAtomicChange(Object element) {
        if (element instanceof IScmChangelist) {
            return (IScmChangelist)element;
        }
        IScmChangelist change = (IScmChangelist)Platform.getAdapterManager().loadAdapter(element, IScmChangelist.class.getName());
        if (change == null) {
            throw new RuntimeException("Could not get IScmChangelist for element " + element);
        }
        return change;
    }

    @Override
    public String getSuggestedNewReviewTitle() {
        ArrayList changelists = Lists.newArrayListWithExpectedSize((int)this.defaultSelection.size());
        for (Object defaultSelectionObj : this.defaultSelection.toArray()) {
            changelists.add(this.toAtomicChange(defaultSelectionObj));
        }
        if (changelists.isEmpty()) {
            return null;
        }
        return AtomicChangesSelectionPage.getSuggestedNewReviewTitle(changelists);
    }

    protected static String getSuggestedNewReviewTitle(List<IScmChangelist> changelists) {
        if (changelists.size() == 1) {
            IScmChangelist changelist = changelists.get(0);
            return changelist.getClientConfiguration().getScmSystem().formatChangelist(changelist.getId()) + " - " + StringUtils.defaultString((String)changelist.getCommitInfo().getComment());
        }
        String title = Strings.joinHumanReadable(changelists, (Function)new Function<IScmChangelist, String>(){

            public String apply(IScmChangelist changelist) {
                return changelist.getClientConfiguration().getScmSystem().formatChangelist(changelist.getId());
            }
        }, (boolean)false);
        return title.length() > 255 ? null : title;
    }

    protected IStructuredSelection getSelection() {
        IStructuredSelection selection = this.isControlCreated() ? (IStructuredSelection)this.viewer.getSelection() : this.defaultSelection;
        return selection;
    }

    protected List<IScmChangelist> getSelectedScmChangeList() {
        IStructuredSelection selection = this.getSelection();
        ArrayList<IScmChangelist> changes = new ArrayList<IScmChangelist>(selection.size());
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            changes.add(this.toAtomicChange(itr.next()));
        }
        return changes;
    }

    protected List<IScmChangelist> sortSelectedChangesets(List<IScmChangelist> changeList) {
        return changeList;
    }

    @Override
    public IScmChangeAdapter getSelectedChangesAdapter() throws ScmCommunicationException {
        List<IScmChangelist> changes = this.getSelectedScmChangeList();
        List<String> exludelist = this.getExcludedMask();
        List<String> includelist = this.getIncludedMask();
        changes = this.sortSelectedChangesets(changes);
        return new ScmChangeAdapter(changes.toArray(new IScmChangelist[changes.size()]), this.atomicChangesLabel, this.options, this.isPostCommit(), exludelist, includelist);
    }

    public List<String> getIncludedMask() {
        return null;
    }

    public List<String> getExcludedMask() {
        return null;
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    protected Control getTopControl() {
        return this.viewer.getControl();
    }

    public void createControl(Composite parent) {
        this.viewer = this.createViewer(parent);
        this.setControl(this.getTopControl());
    }

    protected boolean isPostCommit() {
        return false;
    }

    public void clearView() {
        this.viewer.setInput(null);
        this.viewer.refresh();
    }
}

