/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.preferences.PrefsHelper;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmVersion;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class AtomicChangesTreeViewer
extends TreeViewer {
    public AtomicChangesTreeViewer(Composite parent, int style) {
        super(new Tree(parent, style | 2 | 0x10000 | 0x20 | 0x800 | 0x100 | 0x200));
        Tree tree = this.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        for (Column column : Column.values()) {
            TreeColumn col = new TreeColumn(tree, 16384);
            col.setText(column.text);
            col.setMoveable(true);
            col.setResizable(true);
            col.setData("level", (Object)"changelist");
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(column.weight, true));
        }
        tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem[] childrenItems;
                TreeItem item = (TreeItem)event.item;
                if (item.getData() instanceof IScmChangelist) {
                    for (TreeItem childItem : item.getItems()) {
                        IScmVersion version = (IScmVersion)childItem.getData();
                        childItem.setText(new String[]{version.getDepotPath(), "", "", ""});
                        childItem.setChecked(true);
                    }
                } else if (item.getData() instanceof IScmVersion && item.getParentItem().getData() instanceof IScmChangelist && (childrenItems = item.getItems()).length > 0) {
                    boolean checked = false;
                    for (TreeItem childItem : item.getItems()) {
                        if (!childItem.getChecked()) continue;
                        checked = true;
                        break;
                    }
                    if (!checked) {
                        childrenItems[0].setChecked(true);
                    }
                }
            }
        });
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                if (item.getData() instanceof IScmVersion) {
                    if (item.getParentItem().getData() instanceof IScmChangelist) {
                        item.setChecked(true);
                    } else if (item.getParentItem().getData() instanceof IScmVersion) {
                        for (TreeItem childItem : item.getParentItem().getItems()) {
                            childItem.setChecked(false);
                        }
                        item.setChecked(true);
                    }
                }
            }
        });
        this.setContentProvider((IContentProvider)new TreeViewContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new AtomicChangeLabelProvider());
    }

    private static class TreeViewContentProvider
    implements ITreeContentProvider {
        private static Object[] EMPTY_ARRAY = new Object[0];
        private static int FILE_HISTORY_DEPTH = Long.valueOf(PrefsHelper.getPrefs().getFileHistoryDepth()).intValue();

        private TreeViewContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public Object[] getChildren(Object arg0) {
            try {
                if (arg0 instanceof IScmChangelist) {
                    return ((IScmChangelist)arg0).getVersions(null).toArray();
                }
                if (arg0 instanceof IScmVersion) {
                    List histList = ((IScmVersion)arg0).getHistory(FILE_HISTORY_DEPTH, null);
                    histList.remove(0);
                    return histList.toArray();
                }
            }
            catch (Exception e) {
                CollaboratorUI.log("Error while geting children for arg0 " + arg0, e);
            }
            return null;
        }

        public Object[] getElements(Object arg0) {
            if (arg0 instanceof List) {
                return ((List)arg0).toArray();
            }
            return EMPTY_ARRAY;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof IScmChangelist) {
                return true;
            }
            if (arg0 instanceof IScmVersion) {
                IScmVersion version = (IScmVersion)arg0;
                try {
                    List histVersions = version.getHistory(FILE_HISTORY_DEPTH, null);
                    if (histVersions.size() > 2) {
                        return true;
                    }
                }
                catch (ScmCommunicationException e) {
                    CollaboratorUI.log("Error while getting history for version " + version, e);
                }
            }
            return false;
        }
    }

    private static class AtomicChangeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AtomicChangeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            for (Column column : Column.values()) {
                if (columnIndex != column.index) continue;
                return column.getValue(element);
            }
            throw new RuntimeException("Unexpected table column index: " + columnIndex);
        }
    }

    static enum Column {
        ID(0, "ID", 100){

            @Override
            public String getValue(Object obj) {
                if (obj instanceof IScmChangelist) {
                    return ((IScmChangelist)obj).getId();
                }
                if (obj instanceof IScmVersion) {
                    return ((IScmVersion)obj).getDepotPath();
                }
                return "";
            }
        }
        ,
        AUTHOR(1, "Author", 20){

            @Override
            public String getValue(Object obj) {
                if (obj instanceof IScmChangelist) {
                    return ((IScmChangelist)obj).getCommitInfo().getAuthor();
                }
                if (obj instanceof IScmVersion) {
                    try {
                        return ((IScmVersion)obj).getCommitInfo((IProgressMonitor)new NullProgressMonitor()).getAuthor();
                    }
                    catch (ScmCommunicationException e) {
                        CollaboratorUI.log("Error while geting author of scmVersion ", e);
                    }
                }
                return "";
            }
        }
        ,
        DATE(2, "Date", 20){

            @Override
            public String getValue(Object obj) {
                if (obj instanceof IScmChangelist) {
                    IScmChangelist changelist = (IScmChangelist)obj;
                    Date changelistDate = changelist.getCommitInfo().getDate();
                    if (changelistDate == null) {
                        return "";
                    }
                    return DateFormat.getDateTimeInstance().format(changelistDate);
                }
                if (obj instanceof IScmVersion) {
                    try {
                        IScmVersion version = (IScmVersion)obj;
                        IScmCommitInfo commitInfo = version.getCommitInfo((IProgressMonitor)new NullProgressMonitor());
                        Date commitDate = commitInfo.getDate();
                        String commitDateStr = "";
                        if (commitDate != null) {
                            commitDateStr = DateFormat.getDateTimeInstance().format(commitDate);
                        }
                        return commitDateStr;
                    }
                    catch (ScmCommunicationException e) {
                        CollaboratorUI.log("Error while getting date of scmVersion ", e);
                    }
                }
                return "";
            }
        }
        ,
        COMMENT(3, "Comment", 20){

            @Override
            public String getValue(Object obj) {
                if (obj instanceof IScmChangelist) {
                    return ((IScmChangelist)obj).getCommitInfo().getComment();
                }
                if (obj instanceof IScmVersion) {
                    try {
                        IScmVersion version = (IScmVersion)obj;
                        IScmCommitInfo commitInfo = version.getCommitInfo((IProgressMonitor)new NullProgressMonitor());
                        return commitInfo.getComment();
                    }
                    catch (ScmCommunicationException e) {
                        CollaboratorUI.log("Error while getting comment of scmVersion ", e);
                    }
                }
                return "";
            }
        };

        public final int index;
        public final String text;
        public final int weight;

        private Column(int index, String text, int weight) {
            this.index = index;
            this.text = text;
            this.weight = weight;
        }

        public abstract String getValue(Object var1);
    }
}

