/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.impl.tfs.TfsShelveset;
import com.smartbear.util.commons.ArrayUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AtomicChangesViewer
extends TableViewer {
    private SelectionAdapter sortSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget instanceof TableColumn) {
                TableColumn tableColumn = (TableColumn)selectionEvent.widget;
                AtomicChangesViewer.this.sortTableByColumn(tableColumn);
            }
        }
    };
    private static int DEFAULT_SORT_DIRECTION = 128;

    public AtomicChangesViewer(Composite parent, int style) {
        super(new Table(parent, style | 2 | 0x10000));
        Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        for (Column column : Column.values()) {
            TableColumn col = new TableColumn(table, 0);
            col.setText(column.text);
            col.setMoveable(true);
            col.setResizable(true);
            col.addSelectionListener((SelectionListener)this.sortSelectionAdapter);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(column.weight, true));
        }
        this.setLabelProvider((IBaseLabelProvider)new AtomicChangeLabelProvider());
    }

    private void sortTableByColumn(TableColumn selectedColumn) {
        Table table = this.getTable();
        if (ArrayUtils.isEmpty((Object[])table.getItems()) || selectedColumn == null || ArrayUtils.isEmpty((Object[])table.getColumns())) {
            return;
        }
        List<TableColumn> columnsList = Arrays.asList(table.getColumns());
        int currentColumnIndex = columnsList.contains(selectedColumn) ? columnsList.indexOf(selectedColumn) : 0;
        int sortDirectionChanger = this.getSortDirection(table, selectedColumn);
        List<TableItem> tableItemList = Arrays.asList(table.getItems());
        if (Column.DATE.index == currentColumnIndex) {
            this.orderByDateOrAlphabetically(tableItemList, currentColumnIndex, sortDirectionChanger);
        } else if (Column.ID.index == currentColumnIndex) {
            this.orderAsNumbersOrStrings(tableItemList, currentColumnIndex, sortDirectionChanger);
        } else {
            this.orderAlphabetically(tableItemList, currentColumnIndex, sortDirectionChanger);
        }
        this.reorderData(tableItemList);
        table.redraw();
    }

    private int getSortDirection(Table table, TableColumn selectedColumn) {
        TableColumn sortColumn = table.getSortColumn();
        int currentSortDirection = table.getSortDirection();
        if (sortColumn == selectedColumn) {
            currentSortDirection = currentSortDirection == 128 ? 1024 : 128;
        } else {
            table.setSortColumn(selectedColumn);
            currentSortDirection = DEFAULT_SORT_DIRECTION;
        }
        table.setSortDirection(currentSortDirection);
        return currentSortDirection == DEFAULT_SORT_DIRECTION ? 1 : -1;
    }

    private void reorderData(List<TableItem> tableStrings) {
        List<IScmChangelist> changeLists = new ArrayList();
        if (this.getInput() instanceof List) {
            changeLists = (List)this.getInput();
        }
        if (this.getInput() instanceof TfsShelveset[]) {
            TfsShelveset[] shelvesets;
            for (TfsShelveset shelvest : shelvesets = (TfsShelveset[])this.getInput()) {
                changeLists.add((IScmChangelist)shelvest);
            }
        }
        if (!changeLists.isEmpty()) {
            Map<String, IScmChangelist> idDataMap = this.toIdChangeListMap(changeLists);
            ArrayList<IScmChangelist> reorderedDataSet = new ArrayList<IScmChangelist>();
            for (TableItem line : tableStrings) {
                reorderedDataSet.add(idDataMap.get(line.getText(Column.ID.index)));
            }
            this.setInput(reorderedDataSet);
        }
    }

    private Map<String, IScmChangelist> toIdChangeListMap(List<IScmChangelist> data) {
        HashMap<String, IScmChangelist> map = new HashMap<String, IScmChangelist>();
        for (IScmChangelist changeset : data) {
            map.put(changeset.getId(), changeset);
        }
        return map;
    }

    private void orderByDateOrAlphabetically(List<TableItem> tableStrings, final int currentColumnIndex, final int sortDirectionChanger) {
        final DateFormat dateF = DateFormat.getDateTimeInstance();
        try {
            Collections.sort(tableStrings, new Comparator<TableItem>(){

                @Override
                public int compare(TableItem row1, TableItem row2) {
                    Integer emptyStringCheck = AtomicChangesViewer.this.pushEmptyStringsToTheEndOfList(row1.getText(currentColumnIndex), row2.getText(currentColumnIndex));
                    if (emptyStringCheck != null) {
                        return emptyStringCheck * -sortDirectionChanger;
                    }
                    try {
                        Date date1 = dateF.parse(row1.getText(currentColumnIndex));
                        Date date2 = dateF.parse(row2.getText(currentColumnIndex));
                        return date1.compareTo(date2) * sortDirectionChanger;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(e.getMessage());
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            CollaboratorUI.log("Can't sort by date, sorting alphabetically", e);
            this.orderAlphabetically(tableStrings, currentColumnIndex, sortDirectionChanger);
        }
    }

    private Integer pushEmptyStringsToTheEndOfList(String str1, String str2) {
        if (str1.isEmpty() && !str2.isEmpty()) {
            return 1;
        }
        if (str2.isEmpty() && !str1.isEmpty()) {
            return -1;
        }
        if (str1.isEmpty() && str2.isEmpty()) {
            return 0;
        }
        return null;
    }

    private void orderAsNumbersOrStrings(List<TableItem> tableStrings, final int currentColumnIndex, final int sortDirectionChanger) {
        try {
            Collections.sort(tableStrings, new Comparator<TableItem>(){

                @Override
                public int compare(TableItem row1, TableItem row2) {
                    Integer emptyStringCheck = AtomicChangesViewer.this.pushEmptyStringsToTheEndOfList(row1.getText(currentColumnIndex), row2.getText(currentColumnIndex));
                    if (emptyStringCheck != null) {
                        return emptyStringCheck * sortDirectionChanger;
                    }
                    Integer int1 = new Integer(row1.getText(currentColumnIndex));
                    Integer int2 = new Integer(row2.getText(currentColumnIndex));
                    return int1.compareTo(int2) * sortDirectionChanger;
                }
            });
        }
        catch (NumberFormatException e) {
            CollaboratorUI.log("Can't sort as numeric, sorting alphabetically", e);
            this.orderAlphabetically(tableStrings, currentColumnIndex, sortDirectionChanger);
        }
    }

    private void orderAlphabetically(List<TableItem> tableStrings, final int currentColumnIndex, final int sortDirectionChanger) {
        Collections.sort(tableStrings, new Comparator<TableItem>(){

            @Override
            public int compare(TableItem row1, TableItem row2) {
                Integer emptyStringCheck = AtomicChangesViewer.this.pushEmptyStringsToTheEndOfList(row1.getText(currentColumnIndex), row2.getText(currentColumnIndex));
                if (emptyStringCheck != null) {
                    return emptyStringCheck * sortDirectionChanger;
                }
                String cellText1 = row1.getText(currentColumnIndex);
                String cellText2 = row2.getText(currentColumnIndex);
                return cellText1.compareTo(cellText2) * sortDirectionChanger;
            }
        });
    }

    private static class AtomicChangeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AtomicChangeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IScmChangelist changelist = (IScmChangelist)Platform.getAdapterManager().getAdapter(element, IScmChangelist.class);
            if (changelist == null) {
                CollaboratorUI.log("Could not get IScmChangelist for element " + element, null);
                return "? error ?";
            }
            for (Column column : Column.values()) {
                if (columnIndex != column.index) continue;
                return column.getValue(changelist);
            }
            throw new RuntimeException("Unexpected table column index: " + columnIndex);
        }
    }

    static enum Column {
        ID(0, "ID", 10){

            @Override
            public String getValue(IScmChangelist changelist) {
                return changelist.getId();
            }
        }
        ,
        AUTHOR(1, "Author", 20){

            @Override
            public String getValue(IScmChangelist changelist) {
                return changelist.getCommitInfo().getAuthor();
            }
        }
        ,
        DATE(2, "Date", 20){

            @Override
            public String getValue(IScmChangelist changelist) {
                Date changelistDate = changelist.getCommitInfo().getDate();
                if (changelistDate == null) {
                    return "";
                }
                return DateFormat.getDateTimeInstance().format(changelistDate);
            }
        }
        ,
        COMMENT(3, "Comment", 20){

            @Override
            public String getValue(IScmChangelist changelist) {
                return changelist.getCommitInfo().getComment();
            }
        };

        public final int index;
        public final String text;
        public final int weight;

        private Column(int index, String text, int weight) {
            this.index = index;
            this.text = text;
            this.weight = weight;
        }

        public abstract String getValue(IScmChangelist var1);
    }
}

