/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.smartbear.beans.IScmOptions;
import com.smartbear.ccollab.client.commands.CommandCommit;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.wizards.CommitReviewWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class CommitReviewWizard
extends Wizard {
    private final int reviewId;
    private final IScmOptions options;
    private CommitReviewWizardPage page;

    public CommitReviewWizard(int reviewId, String reviewText, IScmOptions options) {
        this.reviewId = reviewId;
        this.options = options;
        this.setWindowTitle("Commit Changes for " + reviewText);
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new CommitReviewWizardPage(this.reviewId, false, this.options);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String comment = this.page.getComment();
        final boolean recordOnly = this.page.isDismissOnly();
        final CommandCommit.CommitData commitData = this.page.getCommitData();
        final int reviewId = this.reviewId;
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        if (!recordOnly) {
                            CommandCommit.commitReviewContents((CommandCommit.CommitData)commitData, (String)comment, (IProgressMonitor)monitor);
                        }
                        JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
                        CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
                        jsonApi.userApi().dismissCommitTodo(reviewId);
                    }
                    catch (CollabClientException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            CollaboratorUI.openError(this.getShell(), "Error while executing commit", e.getTargetException(), false, true);
            return false;
        }
        catch (InterruptedException e) {
            CollaboratorUI.openError(this.getShell(), "Interruption while executing commit", e, false, false);
            return false;
        }
        return true;
    }
}

