/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.smartbear.CollabClientRuntimeException;
import com.smartbear.beans.IAskUser;
import com.smartbear.beans.IScmOptions;
import com.smartbear.ccollab.client.commands.CommandCommit;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.json.interfaces.review.HasReviewId;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.json.utils.JsonUtils;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ModalAskUser;
import com.smartbear.collaborator.ui.wizards.ProgressWizardDialog;
import com.smartbear.swt.RightSizeText;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class CommitReviewWizardPage
extends WizardPage {
    private final int reviewId;
    private final IScmOptions options;
    private final boolean defaultDismissOnly;
    private RightSizeText commentText;
    private Button dismissOnlyBox;
    private CommandCommit.CommitData commitData;

    public CommitReviewWizardPage(int reviewId, boolean defaultDismissOnly, IScmOptions options) {
        super("commitReviewPage");
        this.setDescription("Please enter a log message");
        this.reviewId = reviewId;
        this.options = options;
        this.defaultDismissOnly = defaultDismissOnly;
    }

    public boolean isDismissOnly() {
        return this.dismissOnlyBox.getSelection();
    }

    public String getComment() {
        return this.commentText.getText();
    }

    public CommandCommit.CommitData getCommitData() {
        if (!this.isPageComplete()) {
            throw new IllegalStateException("Do not have commit data until page complete");
        }
        return this.commitData;
    }

    public void createControl(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.dismissOnlyBox = new Button(composite, 32);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 1;
        this.dismissOnlyBox.setLayoutData((Object)layoutData);
        this.dismissOnlyBox.setText("Only dismiss Action Item (do not attempt to commit)");
        this.dismissOnlyBox.setSelection(this.defaultDismissOnly);
        this.dismissOnlyBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitReviewWizardPage.this.commentText.setEnabled(!CommitReviewWizardPage.this.isDismissOnly());
            }
        });
        this.commentText = new RightSizeText(composite, 2818);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.commentText.setLayoutData(layoutData);
        this.commentText.forceFocus();
        this.setPageComplete(false);
        this.commentText.setEditable(false);
        ((ProgressWizardDialog)this.getContainer()).runAsync(new ProgressWizardDialog.ISimpleRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Initializing", 6);
                Throwable ex = null;
                ReviewInfo reviewInfo = null;
                try {
                    monitor.subTask("Connecting to " + Product.current.getProductName() + " Server");
                    monitor.subTask("Loading Review #" + CommitReviewWizardPage.this.reviewId);
                    JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
                    CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
                    reviewInfo = jsonApi.reviewApi().utilitiesApi().findReviewById(CommitReviewWizardPage.this.reviewId);
                    HasReviewId req2 = (HasReviewId)JsonUtils.create(HasReviewId.class);
                    req2.setReviewId(Integer.valueOf(CommitReviewWizardPage.this.reviewId));
                    List reviewChangelists = jsonApi.reviewApi().reviewMaterialsApi().getVersions(CommitReviewWizardPage.this.reviewId);
                    monitor.worked(1);
                    monitor.subTask("Loading commit data");
                    CommitReviewWizardPage.this.commitData = CommandCommit.buildCommitDataJson((IScmOptions)CommitReviewWizardPage.this.options, (IAskUser)new ModalAskUser(CommitReviewWizardPage.this.getShell()), (ReviewInfo)reviewInfo, (List)reviewChangelists, (boolean)false, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                }
                catch (CollabClientRuntimeException e) {
                    ex = e;
                }
                catch (CollabClientException e) {
                    ex = e;
                }
                if (ex != null) {
                    CollaboratorUI.openError(CommitReviewWizardPage.this.getShell(), "Error initializing Commit page", ex, false, true);
                    return;
                }
                final String comment = CommitReviewWizardPage.this.commitData.calculateDefaultComment();
                String title = "";
                reviewInfo.getDisplayText();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (composite.isDisposed()) {
                            return;
                        }
                        CommitReviewWizardPage.this.commentText.setText(StringUtils.defaultString((String)comment));
                        CommitReviewWizardPage.this.commentText.setEditable(true);
                        CommitReviewWizardPage.this.setTitle("");
                        CommitReviewWizardPage.this.setPageComplete(true);
                    }
                });
            }
        });
    }
}

