/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.google.common.base.Function;
import com.smartbear.beans.IScmOptions;
import com.smartbear.ccollab.client.commands.admin.review.AbstractReviewCommand;
import com.smartbear.ccollab.client.commands.diffs.AddScmDiffsCommandDescriptor;
import com.smartbear.ccollab.client.commands.diffs.CommandAddGitDiffs;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ScmConfig;
import com.smartbear.collaborator.ui.ScmConfigManager;
import com.smartbear.collaborator.ui.UIName;
import com.smartbear.collaborator.ui.diffs.IDiffBuilder;
import com.smartbear.collaborator.ui.diffs.IDiffBuilderListener;
import com.smartbear.collaborator.ui.util.FileDialogSettings;
import com.smartbear.collaborator.ui.util.ISimpleSaveDialogSettings;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.swt.RightSizeText;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.NumberUtils;
import com.smartbear.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class DiffChangesSelectionPage
extends WizardPage
implements IChangesSelectionPage {
    private static final String DIALOG_SETTINGS_DIFF_ARGS = "Diff Args";
    private static final String DIALOG_SETTINGS_SELECTED_TAB = "Selected tab index";
    protected static final int TAB_INDEX_CUSTOM = 0;
    private final AddScmDiffsCommandDescriptor diffCommandDescriptor;
    private final ScmConfig scmConfig;
    private final List<IDiffBuilder> diffBuilders;
    private boolean enableDiffArgsListener = true;
    private boolean userModifiedDiffArgs = false;
    private TabFolder tabFolder;
    private RightSizeText diffArgsText;
    private Map<IDiffBuilder, Button> applyButtons;
    IScmClientConfiguration clientConfig;

    public DiffChangesSelectionPage(AddScmDiffsCommandDescriptor diffCommand, ScmConfig scmConfig, List<IDiffBuilder> diffBuilders) {
        super("Specify Diff");
        this.diffCommandDescriptor = diffCommand;
        this.scmConfig = scmConfig;
        this.setTitle("Specify Diff Options");
        this.setDescription("Specify command-line options to pass directly to the '" + diffCommand.getHumanReadableCommandName() + "' command");
        this.diffBuilders = new ArrayList<IDiffBuilder>(diffBuilders.size() + 1);
        this.diffBuilders.add(new CustomDiffBuilder());
        this.diffBuilders.addAll(diffBuilders);
    }

    public DiffChangesSelectionPage(IScmClientConfiguration clientConfig, AddScmDiffsCommandDescriptor diffCommand, ScmConfig scmConfig, List<IDiffBuilder> diffBuilders) {
        this(diffCommand, scmConfig, diffBuilders);
        this.clientConfig = clientConfig;
    }

    @Override
    public String getSuggestedNewReviewTitle() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.tabFolder = new TabFolder(composite, 0);
        this.tabFolder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.applyButtons = new HashMap<IDiffBuilder, Button>();
        for (IDiffBuilder diffBuilder : this.diffBuilders) {
            TabItem tab = new TabItem(this.tabFolder, 0);
            tab.setText(diffBuilder.getName());
            tab.setToolTipText(diffBuilder.getDescription());
            Composite tabComposite = new Composite((Composite)this.tabFolder, 0);
            tabComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            tabComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            DiffBuilderListener listener = new DiffBuilderListener(diffBuilder);
            diffBuilder.createControl(tabComposite, this.getShell(), listener);
            if (!(diffBuilder instanceof CustomDiffBuilder)) {
                Button applyButton = new Button(tabComposite, 0);
                applyButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).create());
                applyButton.setText("Apply");
                applyButton.addSelectionListener((SelectionListener)listener);
                this.applyButtons.put(diffBuilder, applyButton);
            }
            diffBuilder.init(this.getDiffBuilderDialogSettings(diffBuilder));
            tab.setControl((Control)tabComposite);
        }
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffChangesSelectionPage.this.tabSelectionChanged();
            }
        });
        Label diffArgsLabel = new Label(composite, 0);
        diffArgsLabel.setText("'" + this.diffCommandDescriptor.getHumanReadableCommandName() + "' options:");
        diffArgsLabel.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(1, 1024).create());
        this.diffArgsText = new RightSizeText(composite, 2626);
        SwtUtils.setName((Widget)this.diffArgsText, UIName.WIZARD_DIFF_PAGE_DIFF_OPTIONS_TEXT);
        this.diffArgsText.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.diffArgsText.getLineHeight() * 3).create());
        String diffArgs = this.getScmDialogSettings().get(DIALOG_SETTINGS_DIFF_ARGS);
        this.diffArgsText.setText(StringUtils.defaultString((String)diffArgs));
        this.userModifiedDiffArgs = StringUtils.isNotBlank((String)diffArgs);
        this.diffArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DiffChangesSelectionPage.this.enableDiffArgsListener) {
                    DiffChangesSelectionPage.this.tabFolder.setSelection(0);
                    DiffChangesSelectionPage.this.setMessage(null);
                    DiffChangesSelectionPage.this.userModifiedDiffArgs = true;
                } else {
                    DiffChangesSelectionPage.this.userModifiedDiffArgs = false;
                }
            }
        });
        this.tabFolder.setSelection(NumberUtils.parseInteger((String)this.getScmDialogSettings().get(DIALOG_SETTINGS_SELECTED_TAB), (int)0));
        this.tabSelectionChanged();
        this.setControl((Control)composite);
    }

    private void internalSetDiffArgs(String diffArgs) {
        try {
            this.enableDiffArgsListener = false;
            if (this.diffArgsText != null) {
                this.diffArgsText.setText(StringUtils.defaultString((String)diffArgs));
            }
        }
        finally {
            this.enableDiffArgsListener = true;
        }
    }

    @Override
    public IScmChangeAdapter getSelectedChangesAdapter() throws ScmCommunicationException {
        String[] diffArgsArray;
        String diffArgs;
        final CommandAddGitDiffs diffCommand = new CommandAddGitDiffs(this.clientConfig);
        if (null == this.diffArgsText) {
            diffArgs = "";
            diffArgsArray = new String[]{};
        } else {
            diffArgs = this.diffArgsText.getText();
            diffArgsArray = Strings.parseStringTokens((String)diffArgs);
        }
        diffCommand.setUserDiffArgs(diffArgsArray);
        return new IScmChangeAdapter(){

            public boolean isEmpty() {
                return false;
            }

            public AbstractReviewCommand getUploadCommand() {
                return diffCommand;
            }

            public String getDisplayLabel() {
                return DiffChangesSelectionPage.this.diffCommandDescriptor.getHumanReadableCommandName() + " arguments";
            }

            public String getDisplayContents() {
                return diffArgs;
            }

            public IScmOptions getScmOptions() {
                return DiffChangesSelectionPage.this.scmConfig.getOptions();
            }
        };
    }

    private ISimpleSaveDialogSettings getScmDialogSettings() {
        return new FileDialogSettings(ScmConfigManager.getDialogSettingsFile(this.scmConfig));
    }

    private IDialogSettings getDiffBuilderDialogSettings(IDiffBuilder diffBuilder) {
        return CollaboratorUI.getDialogSettingsSection(this.getScmDialogSettings(), diffBuilder.getName());
    }

    public void dispose() {
        ISimpleSaveDialogSettings dialogSettings = this.getScmDialogSettings();
        if (this.diffArgsText != null) {
            if (this.userModifiedDiffArgs) {
                dialogSettings.put(DIALOG_SETTINGS_DIFF_ARGS, this.diffArgsText.getText());
            } else {
                dialogSettings.put(DIALOG_SETTINGS_DIFF_ARGS, "");
            }
        }
        if (this.tabFolder != null) {
            int selectedTabIndex = this.tabFolder.getSelectionIndex();
            dialogSettings.put(DIALOG_SETTINGS_SELECTED_TAB, selectedTabIndex);
            IDiffBuilder selectedDiffBuilder = this.diffBuilders.get(selectedTabIndex);
            selectedDiffBuilder.save(this.getDiffBuilderDialogSettings(selectedDiffBuilder));
        }
        dialogSettings.save();
        super.dispose();
    }

    private void tabSelectionChanged() {
        Button applyButton;
        IDiffBuilder diffBuilder = this.diffBuilders.get(this.tabFolder.getSelectionIndex());
        this.setMessage(StringUtils.defaultIfEmpty((String)diffBuilder.getWarningMessage(), null), 2);
        if (!this.userModifiedDiffArgs) {
            this.internalSetDiffArgs(diffBuilder.getDiffArgs());
        }
        if ((applyButton = this.applyButtons.get(diffBuilder)) != null) {
            applyButton.setEnabled(this.userModifiedDiffArgs);
        }
    }

    private class CustomDiffBuilder
    implements IDiffBuilder {
        private CustomDiffBuilder() {
        }

        @Override
        public void createControl(Composite parent, Shell parentShell, IDiffBuilderListener listener) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(10, 10).create());
            Label commandLabel = new Label(composite, 0x1000040);
            commandLabel.setText("Enter options to be passed to the '" + DiffChangesSelectionPage.this.diffCommandDescriptor.getHumanReadableCommandName() + "' command.");
            commandLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).minSize(0, -1).create());
            int numArgsToAvoid = DiffChangesSelectionPage.this.diffCommandDescriptor.getArgsToAvoid().size();
            if (numArgsToAvoid > 3) {
                this.createTwoColumnArgsToAvoidControl(composite);
            } else if (numArgsToAvoid > 0) {
                this.createSentenceArgsToAvoidControl(composite);
            }
        }

        private void createSentenceArgsToAvoidControl(Composite parent) {
            List argsToAvoid = DiffChangesSelectionPage.this.diffCommandDescriptor.getArgsToAvoid();
            int numArgs = argsToAvoid.size();
            if (numArgs == 0) {
                return;
            }
            Label argsToAvoidLabel = new Label(parent, 0x1000040);
            argsToAvoidLabel.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(0x1000000, 0x1000000).minSize(0, -1).create());
            StringBuilder avoidMsg = new StringBuilder("Avoid using the ");
            avoidMsg.append(Strings.joinHumanReadable((Collection)argsToAvoid, (Function)Strings.SINGLE_QUOTE_FUNCTION, (boolean)true));
            if (numArgs > 1) {
                avoidMsg.append(" options because they");
            } else {
                avoidMsg.append(" option because it");
            }
            avoidMsg.append(" may change the format of the diff output.");
            argsToAvoidLabel.setText(avoidMsg.toString());
        }

        private void createTwoColumnArgsToAvoidControl(Composite parent) {
            if (!DiffChangesSelectionPage.this.diffCommandDescriptor.getArgsToAvoid().isEmpty()) {
                Label argsLabel = new Label(parent, 0x1000040);
                argsLabel.setText("Avoid using the following options:");
                argsLabel.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(0x1000000, 1024).create());
                Composite composite = new Composite(parent, 0);
                composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                composite.setLayout((Layout)GridLayoutFactory.swtDefaults().spacing(5, 3).numColumns(2).create());
                for (String arg : DiffChangesSelectionPage.this.diffCommandDescriptor.getArgsToAvoid()) {
                    Label argLabel = new Label(composite, 64);
                    argLabel.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).align(0x1000000, 0x1000000).create());
                    argLabel.setText(StringUtils.defaultString((String)arg));
                }
            }
        }

        @Override
        public String getDescription() {
            return "Manually specify diff arguments";
        }

        @Override
        public String getDiffArgs() {
            return DiffChangesSelectionPage.this.diffArgsText.getText();
        }

        @Override
        public String getWarningMessage() {
            return null;
        }

        @Override
        public String getName() {
            return "Custom";
        }

        @Override
        public void init(IDialogSettings dialogSettings) {
        }

        @Override
        public void save(IDialogSettings dialogSettings) {
        }
    }

    private class DiffBuilderListener
    implements IDiffBuilderListener {
        private final IDiffBuilder diffBuilder;

        public DiffBuilderListener(IDiffBuilder diffBuilder) {
            this.diffBuilder = diffBuilder;
        }

        @Override
        public void modified() {
            DiffChangesSelectionPage.this.userModifiedDiffArgs = false;
            DiffChangesSelectionPage.this.setMessage(StringUtils.defaultIfEmpty((String)this.diffBuilder.getWarningMessage(), null), 2);
            DiffChangesSelectionPage.this.internalSetDiffArgs(this.diffBuilder.getDiffArgs());
            Button applyButton = DiffChangesSelectionPage.this.applyButtons.get(this.diffBuilder);
            if (applyButton != null) {
                applyButton.setEnabled(false);
            }
        }

        public void modifyText(ModifyEvent e) {
            this.modified();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.modified();
        }

        public void widgetSelected(SelectionEvent e) {
            this.modified();
        }
    }
}

