/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.smartbear.beans.IScmOptions;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.wizards.AtomicChangesSelectionPage;
import com.smartbear.collaborator.ui.wizards.AtomicChangesViewer;
import com.smartbear.collaborator.ui.wizards.ProgressWizardDialog;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.impl.perforce.PerforceSystem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class LocalChangelistsSelectionPage
extends AtomicChangesSelectionPage {
    private final IScmClientConfiguration clientConfig;

    public LocalChangelistsSelectionPage(IScmClientConfiguration clientConfig, IScmOptions options) {
        this(clientConfig, null, options);
    }

    public LocalChangelistsSelectionPage(IScmClientConfiguration clientConfig, IStructuredSelection initialSelection, IScmOptions options) {
        super(clientConfig.getScmSystem().getLocalAtomicChangelistsText(), options);
        this.clientConfig = clientConfig;
        this.setDefaultSelection(initialSelection);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        final AtomicChangesViewer viewer = new AtomicChangesViewer(parent, 2048);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ((ProgressWizardDialog)this.getContainer()).runAsync(new ProgressWizardDialog.ISimpleRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) {
                IScmChangelist[] changelists = null;
                try {
                    changelists = LocalChangelistsSelectionPage.this.clientConfig.getLocalChangelists(monitor);
                }
                catch (ScmCommunicationException e) {
                    CollaboratorUI.openError(LocalChangelistsSelectionPage.this.getShell(), "Error initializing local changelists", e, false, true);
                }
                final IScmChangelist[] finalChangelists = changelists;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (viewer.getControl().isDisposed()) {
                            return;
                        }
                        if (finalChangelists != null) {
                            if (PerforceSystem.INSTANCE.equals(LocalChangelistsSelectionPage.this.clientConfig.getScmSystem()) && finalChangelists.length == 0) {
                                LocalChangelistsSelectionPage.this.setErrorMessage("No numbered Pending Changelists found.  You must update the default Pending Changelist to a numbered Pending Changelist.");
                                LocalChangelistsSelectionPage.this.setPageComplete(false);
                            } else {
                                viewer.setInput(finalChangelists);
                                viewer.setSelection((ISelection)LocalChangelistsSelectionPage.this.getDefaultSelection(), true);
                            }
                        } else {
                            LocalChangelistsSelectionPage.this.setErrorMessage("Error initializing local changelists");
                            LocalChangelistsSelectionPage.this.setPageComplete(false);
                        }
                    }
                });
            }
        });
        return viewer;
    }
}

