/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.google.common.base.Preconditions;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.util.SafeProgressMonitorPart;
import com.smartbear.collaborator.ui.wizards.TestableWizardDialog;
import com.smartbear.jface.AccumulatingProgressMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProgressWizardDialog
extends TestableWizardDialog {
    private final Thread asyncWorker;
    private final Object progressIndicatorLock = new Object();
    private BlockingQueue<ISimpleRunnableWithProgress> queue;
    private static final int pageMinWidth = 730;
    private static final int pageMinHeight = 620;

    public ProgressWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        Preconditions.checkArgument((boolean)newWizard.needsProgressMonitor(), (Object)"Wizard doesn't need a progress monitor");
        this.queue = new LinkedBlockingQueue<ISimpleRunnableWithProgress>();
        this.asyncWorker = new AsyncWorkerThread();
        this.asyncWorker.setDaemon(true);
    }

    public int open() {
        this.asyncWorker.start();
        return super.open();
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = Math.max(size.x, 730);
        size.y = Math.max(size.y, 620);
        Rectangle clientArea = this.getShell().getDisplay().getPrimaryMonitor().getClientArea();
        size.x = Math.min(size.x, clientArea.width - clientArea.width / 10);
        size.y = Math.min(size.y, clientArea.height - clientArea.height / 10);
        return size;
    }

    protected ProgressMonitorPart getProgressMonitor() {
        return (ProgressMonitorPart)super.getProgressMonitor();
    }

    public void runAsync(ISimpleRunnableWithProgress runnable) {
        this.queue.add(runnable);
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
        return new SafeProgressMonitorPart(composite, (Layout)pmlayout, -1){

            public void setVisible(boolean visible) {
                super.setVisible(true);
            }
        };
    }

    public void run(boolean fork, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (!fork) {
            super.run(fork, cancelable, runnable);
            return;
        }
        super.run(fork, cancelable, new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Object object = ProgressWizardDialog.this.progressIndicatorLock;
                synchronized (object) {
                    runnable.run(monitor);
                }
            }
        });
    }

    public boolean close() {
        boolean result = super.close();
        if (result) {
            this.queue = null;
            this.asyncWorker.interrupt();
        }
        return result;
    }

    private class AsyncWorkerThread
    extends Thread {
        private AsyncWorkerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (ProgressWizardDialog.this.queue != null && ProgressWizardDialog.this.getProgressMonitor() == null) {
                try {
                    AsyncWorkerThread.sleep(500L);
                }
                catch (InterruptedException e) {
                    if (ProgressWizardDialog.this.queue == null) continue;
                    CollaboratorUI.log("Async worker thread interrupted", e);
                    AsyncWorkerThread.interrupted();
                }
            }
            while (ProgressWizardDialog.this.queue != null) {
                try {
                    ISimpleRunnableWithProgress runnable = ProgressWizardDialog.this.queue.take();
                    ProgressMonitorPart progressPart = ProgressWizardDialog.this.getProgressMonitor();
                    if (progressPart == null) {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                        continue;
                    }
                    Object object = ProgressWizardDialog.this.progressIndicatorLock;
                    synchronized (object) {
                        AccumulatingProgressMonitor monitor = new AccumulatingProgressMonitor((IProgressMonitor)progressPart, progressPart.getDisplay());
                        try {
                            runnable.run((IProgressMonitor)monitor);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (ProgressWizardDialog.this.queue == null) continue;
                    CollaboratorUI.log("Async worker thread interrupted", e);
                    AsyncWorkerThread.interrupted();
                }
                catch (Throwable e) {
                    CollaboratorUI.log("Error running operation", e);
                }
            }
        }
    }

    public static interface ISimpleRunnableWithProgress {
        public void run(IProgressMonitor var1);
    }
}

