/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.smartbear.CollabClientRuntimeException;
import com.smartbear.beans.ConfigUtils;
import com.smartbear.ccollab.datamodel.Product;
import com.smartbear.collaborator.Collaborator;
import com.smartbear.collaborator.JsonBatchCommand;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.jobs.AddToExistingReviewJob;
import com.smartbear.collaborator.jobs.AddToNewReviewJob;
import com.smartbear.collaborator.jobs.AddToReviewJob;
import com.smartbear.collaborator.json.api.CollaboratorJsonApi;
import com.smartbear.collaborator.json.interfaces.review.request.ReviewsFindByScmChangelistRequest;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewInfo;
import com.smartbear.collaborator.json.interfaces.review.response.ReviewsFindResponse;
import com.smartbear.collaborator.json.interfaces.user.response.UserInfo;
import com.smartbear.collaborator.json.utils.JsonUtils;
import com.smartbear.collaborator.scm.IScmChangeAdapter;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.UIName;
import com.smartbear.collaborator.ui.wizards.ProgressWizardDialog;
import com.smartbear.collaborator.ui.wizards.ReviewBlock;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.NumberUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public class ReviewPage
extends WizardPage {
    private ReviewBlock block = null;
    private UserInfo userInfo = null;
    private String reviewSpec;
    private String suggestedNewReviewTitle;

    public ReviewPage() {
        super("review", "Select a Review", null);
        this.setPageComplete(false);
    }

    public void setReviewSpec(String reviewSpec) {
        this.reviewSpec = reviewSpec;
    }

    public void suggestReviewTitle(String title) {
        title = StringUtils.replaceChars((String)title, (String)"\r\n", (String)"");
        this.suggestedNewReviewTitle = title = StringUtils.abbreviate((String)title, (int)255);
        if (this.block != null && StringUtils.isBlank((String)this.block.titleText.getText())) {
            this.block.titleText.setText(StringUtils.defaultString((String)this.suggestedNewReviewTitle));
            this.block.titleText.selectAll();
            this.validate();
        }
    }

    public void createControl(Composite parent) {
        this.block = new ReviewBlock(parent, 0);
        SwtUtils.setName((Widget)this.block.newReviewRadioButton, UIName.WIZARD_REVIEW_PAGE_NEW_REVIEW_TOGGLE);
        SwtUtils.setName((Widget)this.block.titleText, UIName.WIZARD_REVIEW_PAGE_TITLE);
        SwtUtils.setName((Widget)this.block.existingReviewRadioButton, UIName.WIZARD_REVIEW_PAGE_EXISTING_REVIEW_TOGGLE);
        SwtUtils.setName((Widget)this.block.reviewList, UIName.WIZARD_REVIEW_PAGE_EXISTING_REVIEWS);
        SwtUtils.setName((Widget)this.block.refreshReviewsButton, UIName.WIZARD_REVIEW_PAGE_REFRESH_REVIEWS);
        this.suggestReviewTitle(this.suggestedNewReviewTitle);
        this.block.titleText.setTextLimit(255);
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!((Button)e.widget).getSelection()) {
                    return;
                }
                ReviewPage.this.radioSelectionChanged();
            }
        };
        this.block.newReviewRadioButton.addSelectionListener((SelectionListener)radioListener);
        this.block.existingReviewRadioButton.addSelectionListener((SelectionListener)radioListener);
        this.block.titleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReviewPage.this.validate();
            }
        });
        this.block.refreshReviewsButton.setEnabled(false);
        this.block.refreshReviewsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.refreshReviews();
            }
        });
        this.block.reviewListViewer.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.validate();
            }
        });
        this.block.reviewListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.block.reviewListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ReviewInfo)element).getDisplayText();
            }
        });
        this.block.existingReviewRadioButton.setText("Add to Existing Review (select to load list from server)");
        this.setControl((Control)this.block);
        this.block.newReviewRadioButton.setSelection(true);
        this.radioSelectionChanged();
        this.validate();
    }

    private void radioSelectionChanged() {
        ScrollBar verticalBar;
        boolean isNew = this.block.newReviewRadioButton.getSelection();
        this.block.titleLabel.setEnabled(isNew);
        this.block.titleText.setEnabled(isNew);
        this.block.existingReviewListLabel.setEnabled(!isNew);
        this.block.refreshReviewsButton.setEnabled(!isNew);
        this.block.reviewList.setEnabled(!isNew);
        ScrollBar horizontalBar = this.block.reviewList.getHorizontalBar();
        if (horizontalBar != null) {
            horizontalBar.setEnabled(!isNew);
        }
        if ((verticalBar = this.block.reviewList.getVerticalBar()) != null) {
            verticalBar.setEnabled(!isNew);
        }
        if (isNew) {
            this.block.titleText.setFocus();
        } else {
            this.block.reviewList.setFocus();
        }
        if (!isNew) {
            this.block.existingReviewRadioButton.setText("Add to Existing Review");
            this.refreshReviews();
        }
        this.validate();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ((ProgressWizardDialog)this.getContainer()).runAsync(new ProgressWizardDialog.ISimpleRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Connecting to " + Product.current.getProductName() + " Server", 100);
                    monitor.subTask("Logging in to Server");
                    try {
                        ReviewPage.this.userInfo = Collaborator.jsonLogin();
                    }
                    catch (CollabClientRuntimeException e) {
                        CollaboratorUI.openError(ReviewPage.this.getWizard().getContainer().getShell(), "Error logging in to " + Product.current.getProductName() + " Server", e, true, false);
                        return;
                    }
                    monitor.worked(20);
                    ReviewInfo reviewInfo = null;
                    if (ReviewPage.this.reviewSpec != null) {
                        int reviewId;
                        if ("new".equals(ReviewPage.this.reviewSpec)) {
                            reviewId = -1;
                        } else if ("ask".equals(ReviewPage.this.reviewSpec)) {
                            reviewId = -1;
                        } else if ("last".equals(ReviewPage.this.reviewSpec)) {
                            reviewId = ConfigUtils.getLastReview();
                        } else {
                            reviewId = NumberUtils.parseInteger((String)ReviewPage.this.reviewSpec, (int)-1);
                            if (reviewId == -1) {
                                CollaboratorUI.openError(ReviewPage.this.getShell(), "'" + ReviewPage.this.reviewSpec + "' is not a valid Review specification - Must be either an integer review-id, 'new', 'ask', or 'last'", null, false, false);
                            }
                        }
                        if (reviewId != -1) {
                            try {
                                JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
                                CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
                                reviewInfo = jsonApi.reviewApi().utilitiesApi().findReviewById(reviewId);
                                if (reviewInfo == null) {
                                    CollaboratorUI.openError(ReviewPage.this.getShell(), "Review '" + reviewId + "' does not exist", null, false, false);
                                }
                            }
                            catch (CollabClientException e) {
                                CollaboratorUI.openError(ReviewPage.this.getWizard().getContainer().getShell(), "Error logging in to " + Product.current.getProductName() + " Server", e, true, false);
                            }
                        } else {
                            reviewInfo = null;
                        }
                    } else {
                        reviewInfo = null;
                    }
                    final ReviewInfo reviewInfoInUI = reviewInfo;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ReviewPage.this.block.isDisposed()) {
                                return;
                            }
                            ReviewPage.this.block.newReviewRadioButton.setEnabled(true);
                            ReviewPage.this.block.existingReviewRadioButton.setEnabled(true);
                            if (reviewInfoInUI != null) {
                                if (ReviewPage.this.block.reviewListViewer.getInput() == null) {
                                    ReviewPage.this.block.reviewListViewer.setInput(Collections.singletonList(reviewInfoInUI));
                                }
                                ReviewPage.this.block.reviewListViewer.setSelection((ISelection)new StructuredSelection((Object)reviewInfoInUI));
                                ReviewPage.this.block.newReviewRadioButton.setSelection(false);
                                ReviewPage.this.block.existingReviewRadioButton.setSelection(true);
                                ReviewPage.this.radioSelectionChanged();
                            }
                            ReviewPage.this.validate();
                        }
                    });
                    monitor.done();
                }
            });
        }
    }

    private void refreshReviews() {
        this.block.refreshReviewsButton.setEnabled(false);
        final ReviewInfo selection = SwtUtils.getSelection(this.block.reviewListViewer.getSelection(), ReviewInfo.class);
        this.block.reviewListViewer.setInput(null);
        this.validate();
        ((ProgressWizardDialog)this.getContainer()).runAsync(new ProgressWizardDialog.ISimpleRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) {
                List reviewInfos = null;
                monitor.beginTask("Loading existing Reviews", -1);
                try {
                    JsonBatchCommand jsonBatchCommand = new JsonBatchCommand();
                    ReviewsFindByScmChangelistRequest request = (ReviewsFindByScmChangelistRequest)JsonUtils.create(ReviewsFindByScmChangelistRequest.class);
                    request.setScmId(null);
                    CollaboratorJsonApi jsonApi = jsonBatchCommand.getCollaboratorJsonApi();
                    ReviewsFindResponse response = jsonApi.reviewApi().utilitiesApi().getReviewsCanUploadChangelists(request);
                    reviewInfos = response.getReviews();
                }
                catch (CollabClientException e) {
                    if (e.getMessage().contains("Errors found:") && e.getMessage().contains("InvalidAuthentication")) {
                        e = new CollabClientException("Your login ticket is invalid.  Please try \"ccollab --use-json-api login\" on the command line and retry this command.");
                    }
                    CollaboratorUI.openError(ReviewPage.this.getShell(), "JSON protocol error in getReviewsCanUploadChangelists", e, false, false);
                }
                monitor.done();
                final List reviewInfosForWidget = reviewInfos;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ReviewPage.this.block.isDisposed()) {
                            return;
                        }
                        ReviewPage.this.block.reviewListViewer.setInput((Object)reviewInfosForWidget);
                        if (selection != null) {
                            ReviewPage.this.block.reviewListViewer.setSelection((ISelection)new StructuredSelection((Object)selection));
                        } else if (reviewInfosForWidget != null && reviewInfosForWidget.size() == 1) {
                            ReviewPage.this.block.reviewListViewer.setSelection((ISelection)new StructuredSelection(reviewInfosForWidget.get(0)));
                        }
                        ReviewPage.this.validate();
                        ReviewPage.this.block.refreshReviewsButton.setEnabled(true);
                    }
                });
            }
        });
    }

    private void validate() {
        if (this.block != null && this.userInfo != null) {
            if (this.block.newReviewRadioButton.getSelection()) {
                boolean hasTitle = StringUtils.isNotBlank((String)this.getReviewTitle());
                if (!hasTitle) {
                    this.setMessage("Enter a title for the New Review", 1);
                } else {
                    this.setMessage(null);
                }
                this.setPageComplete(hasTitle);
            } else {
                boolean haveReview;
                boolean bl = haveReview = this.getReviewInfo() != null;
                if (haveReview) {
                    this.setMessage(null);
                } else {
                    this.setMessage("Select an Existing Review", 1);
                }
                this.setPageComplete(haveReview);
            }
        }
    }

    public ReviewInfo getReviewInfo() {
        if (this.block == null) {
            return null;
        }
        if (this.block.newReviewRadioButton.getSelection()) {
            return null;
        }
        return (ReviewInfo)((IStructuredSelection)this.block.reviewListViewer.getSelection()).getFirstElement();
    }

    public String getReviewTitle() {
        if (this.block == null) {
            return null;
        }
        if (this.block.newReviewRadioButton.getSelection()) {
            return this.block.titleText.getText();
        }
        ReviewInfo reviewInfo = this.getReviewInfo();
        return reviewInfo == null ? null : reviewInfo.getDisplayText();
    }

    public AddToReviewJob getReviewJob(IScmChangeAdapter selectedChangeset, List<File> supportingDocuments) {
        if (this.block == null) {
            return null;
        }
        if (this.block.newReviewRadioButton.getSelection()) {
            return new AddToNewReviewJob(this.userInfo, this.getReviewTitle(), selectedChangeset, supportingDocuments);
        }
        return new AddToExistingReviewJob(this.userInfo, this.getReviewInfo(), selectedChangeset, supportingDocuments);
    }
}

