/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.smartbear.beans.IScmOptions;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.client.exceptions.CollabClientInvalidInputException;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.wizards.AtomicChangesSelectionPage;
import com.smartbear.collaborator.ui.wizards.AtomicChangesViewer;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.swt.RightSizeText;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SubmittedChangelistsSelectionPage
extends AtomicChangesSelectionPage {
    private static final String ID_SEPARATORS = " ,";
    private Composite topControl;
    private final IScmClientConfiguration clientConfig;
    protected List<IScmChangelist> initialSelection;

    public SubmittedChangelistsSelectionPage(IScmClientConfiguration clientConfig, IScmOptions options) {
        this(clientConfig, null, options);
    }

    public SubmittedChangelistsSelectionPage(IScmClientConfiguration clientConfig, IStructuredSelection initialSelection, IScmOptions options) {
        super(clientConfig.getScmSystem().getSubmittedAtomicChangelistsText(), options);
        this.clientConfig = clientConfig;
        this.setDefaultSelection(initialSelection);
        this.initialSelection = initialSelection == null ? Collections.emptyList() : initialSelection.toList();
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.topControl = new Composite(parent, 0);
        this.topControl.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        final AtomicChangesViewer viewer = new AtomicChangesViewer(this.topControl, 2048);
        viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, true).create());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(this.initialSelection);
        viewer.setSelection((ISelection)this.getDefaultSelection(), true);
        Label label = new Label(this.topControl, 0);
        label.setText("Enter " + this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText() + " IDs:");
        label.setToolTipText("IDs may be separated with spaces or commas");
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000000).create());
        final RightSizeText text = new RightSizeText(this.topControl, 2052);
        text.setLayoutData(GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        text.setFocus();
        final Button addButton = new Button(this.topControl, 8);
        addButton.setText("Add");
        addButton.setEnabled(false);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                addButton.setEnabled(StringUtils.isNotBlank((String)text.getText()));
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmittedChangelistsSelectionPage.this.setErrorMessage(null);
                final String[] ids = StringUtils.split((String)text.getText(), (String)SubmittedChangelistsSelectionPage.ID_SEPARATORS);
                final ArrayList newChangelists = new ArrayList(ids.length);
                try {
                    SubmittedChangelistsSelectionPage.this.getContainer().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                HashMap<String, IScmChangelist> loadedChangelistsById = new HashMap<String, IScmChangelist>();
                                for (IScmChangelist changelist : (List)viewer.getInput()) {
                                    loadedChangelistsById.put(changelist.getId(), changelist);
                                }
                                IteratorWithProgress itr = IteratorWithProgress.getIterator(Arrays.asList(ids), (String)("Loading " + SubmittedChangelistsSelectionPage.this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()), (IProgressMonitor)monitor);
                                while (itr.hasNext()) {
                                    String id = (String)itr.next();
                                    if (loadedChangelistsById.containsKey(id)) continue;
                                    IScmChangelist atomicChange = SubmittedChangelistsSelectionPage.this.clientConfig.getChangelist(id, itr.getIterationProgressMonitor());
                                    if (atomicChange == null) {
                                        throw new CollabClientInvalidInputException("Could not find changelist with ID '" + id + "'");
                                    }
                                    loadedChangelistsById.put(atomicChange.getId(), atomicChange);
                                    newChangelists.add(atomicChange);
                                }
                            }
                            catch (ScmCommunicationException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (CollabClientInvalidInputException e) {
                                throw new InvocationTargetException(e);
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                    List selection = ((IStructuredSelection)viewer.getSelection()).toList();
                    List input = (List)viewer.getInput();
                    ArrayList newInput = new ArrayList(input);
                    newInput.addAll(newChangelists);
                    viewer.setInput(newInput);
                    ArrayList newSelection = new ArrayList(selection);
                    newSelection.addAll(newChangelists);
                    viewer.setSelection((ISelection)new StructuredSelection(newSelection), true);
                    text.setText("");
                    addButton.setEnabled(false);
                }
                catch (InvocationTargetException ex) {
                    SubmittedChangelistsSelectionPage.this.setErrorMessage(ex.getCause().getMessage());
                    CollaboratorUI.log("Error loading changelist IDs:" + Arrays.asList(ids), ex.getCause());
                }
                catch (InterruptedException ex) {
                    SubmittedChangelistsSelectionPage.this.setErrorMessage(ex.getMessage());
                    CollaboratorUI.log("Error loading changelist IDs:" + Arrays.asList(ids), ex);
                    Thread.currentThread().interrupt();
                }
            }
        });
        return viewer;
    }

    @Override
    protected Control getTopControl() {
        return this.topControl;
    }
}

