/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.wizards;

import com.smartbear.beans.IScmOptions;
import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.wizards.AtomicChangesSelectionPage;
import com.smartbear.collaborator.ui.wizards.AtomicChangesViewer;
import com.smartbear.progress.IteratorWithProgress;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.ScmUtils;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.NumberUtils;
import com.smartbear.util.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SubmittedChangelistsSelectionUpdatedPage
extends AtomicChangesSelectionPage {
    private static final String DISPLAY_CHANGELIST_GROUP_TEXT = "List conditions";
    private static final String SOME_CHANGELIST_RADIO_BUTTON_TEXT = "%s by IDs";
    private static final String SOME_CHANGELIST_TEXT_BOX_HINT = "IDs can be separated with spaces or commas";
    public static final String ERROR_SPECIFY_FROM_CHANGELIST_ID = "Please specify %s number to start from.";
    private static final String ID_RANGE_RADIO_BUTTON_TEXT = "%s range";
    private static final String ID_RANGE_FROM_LABEL = "From: ";
    private static final String ID_RANGE_TO_LABEL = "To: ";
    private static final String ID_RANGE_TO_INFO_LABEL = "(leave blank to list up to the latest changes)";
    private static final String DATE_RANGE_RADIO_BUTTON_TEXT = "Created date";
    private static final String DATE_RANGE_BETWEEN_LABEL = "Between: ";
    private static final String DATE_RANGE_AND_LABEL = "And: ";
    private static final String DISPLAY_BUTTON_TEXT = "List changes";
    private static final String NO_CHANGELIST_FOUND_CAPTION = "List %s";
    private static final String NO_CHANGELIST_FOUND_MESSAGE = "No %s matching the current filter criteria were found.";
    public static final String ERROR_INVALID_CHANGELIST_ID = "'%s' is not a valid %s number.";
    public static final String ERROR_SPECIFY_CHANGELIST_IDS = "Please specify some %s numbers.";
    public static final String ERROR_LOADING_CHANGELIST_IDS = "Error loading %s IDs";
    private static final String EXCLUDE_FILE_TYPES = "Exclude";
    private static final String INCLUDE_FILE_TYPES = "Include";
    private static final String DISPLAY_EXCLUDE_INCLUDE_TEXT = "Include/Exclude file types";
    private static final String DISPLAY_TOOL_TIP_INCLUDE_EXCLUDE = " files from changelist(s), that match specified mask";
    private static final String ID_SEPARATORS = " ,";
    private final IScmClientConfiguration clientConfig;
    private Button btn_ChangeListsById;
    private Text txt_ChangeListsById;
    private Button btn_ChangeListsByDate;
    private Label lab_startDate;
    private DateTime datePic_start;
    private Label lab_endDate;
    private DateTime datePic_end;
    private Button btn_ChangeListRange;
    private Label lab_from;
    private Text txt_from;
    private Label lab_to;
    private Text txt_to;
    private Label lab_to_info;
    private SelectionAdapter radioButtonSelectionAdapter;
    private GridData indentControlLayoutData;
    private GridData fillColumnLayoutData;
    private GridData minWidthLayoutData;
    private Composite rootControl;
    public Text txt_exclude;
    public Text txt_include;
    public int margin = 8;
    public int displayGroupColumnCount = 5;

    public SubmittedChangelistsSelectionUpdatedPage(IScmClientConfiguration clientConfig, IScmOptions options) {
        this(clientConfig, null, options);
    }

    public SubmittedChangelistsSelectionUpdatedPage(IScmClientConfiguration clientConfig, IStructuredSelection initialSelection, IScmOptions options) {
        super(clientConfig.getScmSystem().getSubmittedAtomicChangelistsText(), options);
        this.clientConfig = clientConfig;
        this.setDefaultSelection(initialSelection);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        int rootControlsColumnsCount = 1;
        this.rootControl = new Composite(parent, 0);
        this.rootControl.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(rootControlsColumnsCount).create());
        this.initCommonLayoutData();
        this.createTopControls(this.rootControl, rootControlsColumnsCount);
        this.viewer = this.createViewerControl(this.rootControl, rootControlsColumnsCount);
        this.createBottomControls(this.rootControl, rootControlsColumnsCount);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SubmittedChangelistsSelectionUpdatedPage.this.setEnableMask(true);
            }
        });
        return this.viewer;
    }

    private void createBottomControls(Composite parent, int columnsCount) {
        GridLayout displayGroupLayout = GridLayoutFactory.fillDefaults().numColumns(this.displayGroupColumnCount).create();
        SwtUtils.setMargins(displayGroupLayout, this.margin);
        Group maskingGroup = new Group(parent, 16);
        maskingGroup.setLayout((Layout)displayGroupLayout);
        maskingGroup.setText(DISPLAY_EXCLUDE_INCLUDE_TEXT);
        GridDataFactory.generate((Control)maskingGroup, (int)columnsCount, (int)1);
        this.createExcludeButton(maskingGroup);
        this.createIncludeButton(maskingGroup);
    }

    @Override
    protected Control getTopControl() {
        return this.rootControl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private QueryParams getQueryChangeListsParams() {
        String changelistIds;
        QueryParams queryParams = new QueryParams();
        if (this.btn_ChangeListsById.getSelection()) {
            changelistIds = this.txt_ChangeListsById.getText();
            if (Strings.isNullOrEmpty((String)changelistIds)) {
                this.setErrorMessage(String.format(ERROR_SPECIFY_CHANGELIST_IDS, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()));
                this.setEnableMask(false);
                return null;
            }
        } else {
            String toTxt;
            if (!this.btn_ChangeListRange.getSelection()) {
                if (!this.btn_ChangeListsByDate.getSelection()) return queryParams;
                Calendar fromDate = Calendar.getInstance();
                fromDate.set(this.datePic_start.getYear(), this.datePic_start.getMonth(), this.datePic_start.getDay(), 0, 0, 0);
                queryParams.fromDate = fromDate.getTime();
                Calendar toDate = Calendar.getInstance();
                toDate.set(this.datePic_end.getYear(), this.datePic_end.getMonth(), this.datePic_end.getDay(), 23, 59, 59);
                queryParams.toDate = toDate.getTime();
                return queryParams;
            }
            String fromTxt = this.txt_from.getText();
            if (Strings.isNullOrEmpty((String)fromTxt)) {
                this.setErrorMessage(String.format(ERROR_SPECIFY_FROM_CHANGELIST_ID, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()));
                this.setEnableMask(false);
                return null;
            }
            if (ScmUtils.SCMS_WITH_NEUMERIC_COMMITID.contains(this.clientConfig.getScmSystem().getName())) {
                Integer intId = NumberUtils.parseInteger((String)fromTxt, (int)0);
                if (intId <= 0) {
                    this.setErrorMessage(String.format(ERROR_INVALID_CHANGELIST_ID, fromTxt, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()));
                    return null;
                }
                queryParams.startId = fromTxt;
            } else {
                queryParams.startId = fromTxt;
            }
            if (!Strings.containsData((String)(toTxt = this.txt_to.getText()))) return queryParams;
            if (!ScmUtils.SCMS_WITH_NEUMERIC_COMMITID.contains(this.clientConfig.getScmSystem().getName())) {
                queryParams.endId = toTxt;
                return queryParams;
            }
            Integer endId = NumberUtils.parseInteger((String)toTxt, (int)0);
            if (endId > 0) {
                queryParams.endId = toTxt;
                if (endId >= Integer.parseInt(queryParams.startId)) return queryParams;
                String tmp = queryParams.endId;
                queryParams.endId = queryParams.startId;
                queryParams.startId = tmp;
                return queryParams;
            }
            this.setErrorMessage(String.format(ERROR_INVALID_CHANGELIST_ID, toTxt, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()));
            this.setEnableMask(false);
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(changelistIds, ID_SEPARATORS);
        queryParams.specificIds = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String stringId = stringTokenizer.nextToken();
            if (ScmUtils.SCMS_WITH_NEUMERIC_COMMITID.contains(this.clientConfig.getScmSystem().getName())) {
                Integer intId = NumberUtils.parseInteger((String)stringId, (int)0);
                if (intId <= 0) {
                    this.setErrorMessage(String.format(ERROR_INVALID_CHANGELIST_ID, stringId, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()));
                    this.setEnableMask(false);
                    return null;
                }
                queryParams.specificIds.add(stringId);
                continue;
            }
            queryParams.specificIds.add(stringId);
        }
        return queryParams;
    }

    private void displayChangelist() {
        if (this.viewer == null) {
            return;
        }
        final QueryParams queryParams = this.getQueryChangeListsParams();
        if (queryParams == null) {
            this.viewer.setInput(null);
            return;
        }
        final boolean queryRangeById = queryParams.startId != null;
        final boolean queryRangeByDate = queryParams.fromDate != null && queryParams.toDate != null;
        final boolean querySomeIds = queryParams.specificIds != null && queryParams.specificIds.size() > 0;
        final ArrayList newChangelist = new ArrayList();
        try {
            IWizardContainer container = this.getWizard().getContainer();
            container.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", -1);
                    try {
                        List<IScmChangelist> updatedChangelist = null;
                        if (querySomeIds) {
                            updatedChangelist = SubmittedChangelistsSelectionUpdatedPage.this.getChangelistById(queryParams.specificIds, monitor);
                        } else if (queryRangeById) {
                            String startId = queryParams.startId;
                            String endId = Strings.isNullOrEmpty((String)queryParams.endId) ? "" : queryParams.endId;
                            updatedChangelist = Arrays.asList(SubmittedChangelistsSelectionUpdatedPage.this.clientConfig.getChangelistByIdRange(startId, endId, monitor));
                        } else if (queryRangeByDate) {
                            updatedChangelist = Arrays.asList(SubmittedChangelistsSelectionUpdatedPage.this.clientConfig.getChangelistByDateRange(queryParams.fromDate, queryParams.toDate, monitor));
                        }
                        newChangelist.addAll(updatedChangelist);
                    }
                    catch (ScmCommunicationException e) {
                        throw new InvocationTargetException(e);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            if (newChangelist.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)String.format(NO_CHANGELIST_FOUND_CAPTION, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()), (String)String.format(NO_CHANGELIST_FOUND_MESSAGE, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()));
                this.clearView();
                this.setEnableMask(false);
            } else {
                this.viewer.setInput(newChangelist);
                if (querySomeIds) {
                    this.setEnableMask(true);
                    this.viewer.setSelection((ISelection)new StructuredSelection(newChangelist), true);
                }
            }
        }
        catch (InvocationTargetException e) {
            this.clearView();
            this.setErrorMessage(e.getCause().getMessage());
            CollaboratorUI.log(String.format(ERROR_LOADING_CHANGELIST_IDS, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()), e);
            this.setEnableMask(false);
        }
        catch (InterruptedException e) {
            this.clearView();
            this.setErrorMessage(e.getMessage());
            CollaboratorUI.log(String.format(ERROR_LOADING_CHANGELIST_IDS, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()), e);
            Thread.currentThread().interrupt();
            this.setEnableMask(false);
        }
    }

    private List<IScmChangelist> getChangelistById(List<String> changeListIds, IProgressMonitor monitor) throws ScmCommunicationException {
        ArrayList<IScmChangelist> newChangelists = new ArrayList<IScmChangelist>(changeListIds.size());
        IteratorWithProgress itr = IteratorWithProgress.getIterator(changeListIds, (String)("Loading " + this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()), (IProgressMonitor)monitor);
        while (itr.hasNext()) {
            String id = (String)itr.next();
            IScmChangelist atomicChange = this.clientConfig.getChangelist(id, itr.getIterationProgressMonitor());
            newChangelists.add(atomicChange);
        }
        return newChangelists;
    }

    private void initRadioButtonSelectionListener() {
        this.radioButtonSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Widget widget = e.widget;
                boolean isByIdEnabled = false;
                boolean isByRangeEnabled = false;
                boolean isByDateEnabled = false;
                if (widget.equals(SubmittedChangelistsSelectionUpdatedPage.this.btn_ChangeListsById)) {
                    isByIdEnabled = true;
                } else if (widget.equals(SubmittedChangelistsSelectionUpdatedPage.this.btn_ChangeListRange)) {
                    isByRangeEnabled = true;
                } else if (widget.equals(SubmittedChangelistsSelectionUpdatedPage.this.btn_ChangeListsByDate)) {
                    isByDateEnabled = true;
                }
                SubmittedChangelistsSelectionUpdatedPage.this.txt_ChangeListsById.setEnabled(isByIdEnabled);
                SubmittedChangelistsSelectionUpdatedPage.this.lab_from.setEnabled(isByRangeEnabled);
                SubmittedChangelistsSelectionUpdatedPage.this.txt_from.setEnabled(isByRangeEnabled);
                SubmittedChangelistsSelectionUpdatedPage.this.lab_to.setEnabled(isByRangeEnabled);
                SubmittedChangelistsSelectionUpdatedPage.this.txt_to.setEnabled(isByRangeEnabled);
                SubmittedChangelistsSelectionUpdatedPage.this.lab_to_info.setEnabled(isByRangeEnabled);
                SubmittedChangelistsSelectionUpdatedPage.this.lab_startDate.setEnabled(isByDateEnabled);
                SubmittedChangelistsSelectionUpdatedPage.this.datePic_start.setEnabled(isByDateEnabled);
                SubmittedChangelistsSelectionUpdatedPage.this.lab_endDate.setEnabled(isByDateEnabled);
                SubmittedChangelistsSelectionUpdatedPage.this.datePic_end.setEnabled(isByDateEnabled);
            }
        };
    }

    private void initCommonLayoutData() {
        this.indentControlLayoutData = new GridData();
        this.indentControlLayoutData.horizontalIndent = 24;
        this.fillColumnLayoutData = new GridData();
        this.fillColumnLayoutData.horizontalAlignment = 4;
        this.minWidthLayoutData = new GridData();
        this.minWidthLayoutData.widthHint = 112;
    }

    private void createSomeChangeListsControls(Composite parent) {
        this.btn_ChangeListsById = new Button(parent, 16);
        this.btn_ChangeListsById.setText(String.format(SOME_CHANGELIST_RADIO_BUTTON_TEXT, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()));
        this.btn_ChangeListsById.setSelection(false);
        this.btn_ChangeListsById.addSelectionListener((SelectionListener)this.radioButtonSelectionAdapter);
        GridDataFactory.generate((Control)this.btn_ChangeListsById, (int)this.displayGroupColumnCount, (int)1);
        this.txt_ChangeListsById = new Text(parent, 2052);
        this.txt_ChangeListsById.setToolTipText(SOME_CHANGELIST_TEXT_BOX_HINT);
        this.txt_ChangeListsById.setLayoutData((Object)GridDataFactory.fillDefaults().indent(24, 0).span(this.displayGroupColumnCount, 1).create());
        this.txt_ChangeListsById.setEnabled(false);
        this.txt_ChangeListsById.addTraverseListener((TraverseListener)new EnterKeyPressedListener());
    }

    private void createRangeByIdControls(Composite parent) {
        this.btn_ChangeListRange = new Button(parent, 16);
        this.btn_ChangeListRange.setText(String.format(ID_RANGE_RADIO_BUTTON_TEXT, this.clientConfig.getScmSystem().getSubmittedAtomicChangelistsText()));
        this.btn_ChangeListRange.setSelection(false);
        this.btn_ChangeListRange.addSelectionListener((SelectionListener)this.radioButtonSelectionAdapter);
        GridDataFactory.generate((Control)this.btn_ChangeListRange, (int)this.displayGroupColumnCount, (int)1);
        this.lab_from = new Label(parent, 16384);
        this.lab_from.setText(ID_RANGE_FROM_LABEL);
        this.lab_from.setLayoutData((Object)this.indentControlLayoutData);
        this.lab_from.setEnabled(false);
        this.txt_from = new Text(parent, 2052);
        this.txt_from.setLayoutData((Object)this.minWidthLayoutData);
        this.txt_from.setEnabled(false);
        this.lab_to = new Label(parent, 16384);
        this.lab_to.setText(ID_RANGE_TO_LABEL);
        this.lab_to.setEnabled(false);
        this.txt_to = new Text(parent, 2052);
        this.txt_to.setLayoutData((Object)this.minWidthLayoutData);
        this.txt_to.setEnabled(false);
        this.lab_to_info = new Label(parent, 16384);
        this.lab_to_info.setText(ID_RANGE_TO_INFO_LABEL);
        this.lab_to_info.setEnabled(false);
    }

    private void createRangeByDateControls(Composite parent) {
        this.btn_ChangeListsByDate = new Button(parent, 16);
        this.btn_ChangeListsByDate.setText(DATE_RANGE_RADIO_BUTTON_TEXT);
        this.btn_ChangeListsByDate.setSelection(false);
        this.btn_ChangeListsByDate.addSelectionListener((SelectionListener)this.radioButtonSelectionAdapter);
        GridDataFactory.generate((Control)this.btn_ChangeListsByDate, (int)this.displayGroupColumnCount, (int)1);
        this.lab_startDate = new Label(parent, 16384);
        this.lab_startDate.setText(DATE_RANGE_BETWEEN_LABEL);
        this.lab_startDate.setLayoutData((Object)this.indentControlLayoutData);
        this.lab_startDate.setEnabled(false);
        Calendar now = Calendar.getInstance();
        this.datePic_start = new DateTime(parent, 2084);
        this.datePic_start.setLayoutData((Object)this.fillColumnLayoutData);
        this.datePic_start.setDate(now.get(1), now.get(2), now.get(5));
        this.datePic_start.setEnabled(false);
        this.lab_endDate = new Label(parent, 16384);
        this.lab_endDate.setText(DATE_RANGE_AND_LABEL);
        this.lab_endDate.setEnabled(false);
        this.datePic_end = new DateTime(parent, 2084);
        this.datePic_end.setLayoutData((Object)this.fillColumnLayoutData);
        this.datePic_end.setDate(now.get(1), now.get(2), now.get(5));
        this.datePic_end.setEnabled(false);
    }

    private void createDisplayButton(Composite parent) {
        GridData displayButtonLayoutData = new GridData();
        displayButtonLayoutData.widthHint = -1;
        displayButtonLayoutData.grabExcessHorizontalSpace = true;
        displayButtonLayoutData.horizontalAlignment = 131072;
        displayButtonLayoutData.verticalAlignment = 0x1000000;
        Button bnt_display = new Button(parent, 8);
        bnt_display.setText(DISPLAY_BUTTON_TEXT);
        bnt_display.setLayoutData((Object)displayButtonLayoutData);
        bnt_display.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmittedChangelistsSelectionUpdatedPage.this.setErrorMessage(null);
                SubmittedChangelistsSelectionUpdatedPage.this.displayChangelist();
            }
        });
    }

    public void createTopControls(Composite parent, int columnsCount) {
        this.initRadioButtonSelectionListener();
        GridLayout displayGroupLayout = GridLayoutFactory.fillDefaults().numColumns(this.displayGroupColumnCount).create();
        SwtUtils.setMargins(displayGroupLayout, this.margin);
        Group displayGroup = new Group(parent, 16);
        displayGroup.setLayout((Layout)displayGroupLayout);
        displayGroup.setText(DISPLAY_CHANGELIST_GROUP_TEXT);
        GridDataFactory.generate((Control)displayGroup, (int)columnsCount, (int)1);
        this.createSomeChangeListsControls((Composite)displayGroup);
        this.createRangeByIdControls((Composite)displayGroup);
        this.createRangeByDateControls((Composite)displayGroup);
        this.createDisplayButton((Composite)displayGroup);
    }

    private void createIncludeButton(Group parent) {
        GridData labelIncludeGrid = new GridData();
        labelIncludeGrid.horizontalIndent = 24;
        Label lab_include = new Label((Composite)parent, 16384);
        lab_include.setText(INCLUDE_FILE_TYPES);
        lab_include.setLayoutData((Object)labelIncludeGrid);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.txt_include = new Text((Composite)parent, 2052);
        this.txt_include.setToolTipText("Include files from changelist(s), that match specified mask");
        this.txt_include.setLayoutData((Object)gd);
        this.txt_include.setEnabled(false);
    }

    private void createExcludeButton(Group parent) {
        GridData labelExcludeGrid = new GridData();
        labelExcludeGrid.horizontalIndent = 24;
        Label lab_exclude = new Label((Composite)parent, 16384);
        lab_exclude.setText(EXCLUDE_FILE_TYPES);
        lab_exclude.setLayoutData((Object)labelExcludeGrid);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.txt_exclude = new Text((Composite)parent, 2052);
        this.txt_exclude.setToolTipText("Exclude files from changelist(s), that match specified mask");
        this.txt_exclude.setLayoutData((Object)gd);
        this.txt_exclude.setEnabled(false);
    }

    private StructuredViewer createViewerControl(Composite parent, int columnsCount) {
        AtomicChangesViewer viewer = new AtomicChangesViewer(parent, 2048);
        viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().span(columnsCount, 1).grab(true, true).create());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setSelection((ISelection)this.getDefaultSelection(), true);
        return viewer;
    }

    @Override
    public List<String> getExcludedMask() {
        if (this.txt_exclude.getText() != null || !this.txt_exclude.getText().isEmpty()) {
            return Arrays.stream(this.txt_exclude.getText().split(",")).map(String::trim).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<String> getIncludedMask() {
        if (this.txt_include.getText() != null || !this.txt_include.getText().isEmpty()) {
            return Arrays.stream(this.txt_include.getText().split(",")).map(String::trim).collect(Collectors.toList());
        }
        return null;
    }

    public void setEnableMask(boolean val) {
        this.txt_exclude.setEnabled(val);
        this.txt_include.setEnabled(val);
    }

    public class QueryParams {
        public String startId = null;
        public String endId = null;
        public List<String> specificIds = null;
        public Date fromDate = null;
        public Date toDate = null;
    }

    class EnterKeyPressedListener
    implements TraverseListener {
        EnterKeyPressedListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.keyCode == 13) {
                SubmittedChangelistsSelectionUpdatedPage.this.setErrorMessage(null);
                SubmittedChangelistsSelectionUpdatedPage.this.displayChangelist();
                e.doit = false;
            }
        }
    }
}

