/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jface;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;

public class LabelProviderImageManager {
    private final Map<String, Image> imageCache = Maps.newHashMap();

    public Image createFromExtension(String fileName) {
        ImageData imageData;
        String extension = FilenameUtils.getExtension((String)fileName);
        Image image = this.imageCache.get(extension);
        if (image != null) {
            return image;
        }
        Program program = Program.findProgram((String)extension);
        if (program != null && (imageData = program.getImageData()) != null) {
            image = ImageDescriptor.createFromImageData((ImageData)imageData).createImage();
            this.imageCache.put(extension, image);
        }
        return image;
    }

    public void dispose() {
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
        this.imageCache.clear();
    }
}

