/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jface;

import com.google.common.collect.Lists;
import com.smartbear.swt.SwtUtils;
import com.smartbear.util.commons.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;

public class LinkListViewer
extends AbstractListViewer {
    private static final Pattern LINK = Pattern.compile("^<a href=\"\\d+\">(.*)</a>$", 8);
    private final Link link;

    public LinkListViewer(Composite parent) {
        this(parent, 0);
    }

    public LinkListViewer(Composite parent, int style) {
        this(new Link(parent, style));
    }

    public LinkListViewer(Link link) {
        this.link = link;
    }

    private List<String> getLabels() {
        ArrayList linkList = Lists.newArrayList();
        Matcher matcher = LINK.matcher(this.link.getText());
        while (matcher.find()) {
            linkList.add(matcher.group(1));
        }
        return linkList;
    }

    private void setLabels(List<String> labels) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < labels.size(); ++i) {
            if (i != 0) {
                text.append('\n');
            }
            text.append("<a href=\"").append(i).append("\">").append(SwtUtils.escapeMnemonics(labels.get(i))).append("</a>");
        }
        this.link.setText(text.toString());
    }

    protected void listAdd(String string, int index) {
        List<String> labels = this.getLabels();
        labels.add(index, string);
        this.setLabels(labels);
    }

    protected void listDeselectAll() {
    }

    protected int listGetItemCount() {
        return this.getLabels().size();
    }

    protected int[] listGetSelectionIndices() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    protected void listRemove(int index) {
        List<String> labels = this.getLabels();
        labels.remove(index);
        this.setLabels(labels);
    }

    protected void listRemoveAll() {
        this.setLabels(Collections.emptyList());
    }

    protected void listSetItem(int index, String string) {
        List<String> labels = this.getLabels();
        labels.set(index, string);
        this.setLabels(labels);
    }

    protected void listSetItems(String[] labels) {
        this.setLabels(Arrays.asList(labels));
    }

    protected void listSetSelection(int[] ixs) {
    }

    protected void listShowSelection() {
    }

    public void reveal(Object element) {
    }

    public Link getControl() {
        return this.link;
    }
}

