/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jface;

import com.smartbear.jface.LinkListViewer;
import com.smartbear.jface.StructuredViewer2;
import com.smartbear.util.ListenerList;
import com.smartbear.util.NumberUtils;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;

public class LinkListViewer2<I, E>
extends StructuredViewer2<I, E> {
    private final ListenerList<LinkSelectionListener<E>> listeners = new ListenerList();

    public LinkListViewer2(Composite parent) {
        this(new LinkListViewer(parent));
    }

    public LinkListViewer2(Composite parent, int style) {
        this(new LinkListViewer(parent, style));
    }

    public LinkListViewer2(Link link) {
        this(new LinkListViewer(link));
    }

    public LinkListViewer2(LinkListViewer viewer) {
        super((StructuredViewer)viewer);
        viewer.getControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NumberUtils.parseInteger((String)e.text, (int)-1);
                Object element = LinkListViewer2.this.getInner().getElementAt(index);
                if (element == null) {
                    return;
                }
                for (LinkSelectionListener listener : LinkListViewer2.this.listeners.getListeners()) {
                    listener.selected(element);
                }
            }
        });
    }

    public LinkListViewer getInner() {
        return (LinkListViewer)super.getInner();
    }

    public Link getControl() {
        return this.getInner().getControl();
    }

    public void addLinkSelectionListener(LinkSelectionListener<E> listener) {
        this.listeners.add(listener);
    }

    public void removeLinkSelectionListener(LinkSelectionListener<E> listener) {
        this.listeners.remove(listener);
    }

    public static <I, E> LinkListViewer2<I, E> wrap(LinkListViewer viewer) {
        return new LinkListViewer2<I, E>(viewer);
    }

    public static <I, E> LinkListViewer2<I, E> create(Link link) {
        return new LinkListViewer2<I, E>(link);
    }

    public static <I, E> LinkListViewer2<I, E> create(Composite parent) {
        return new LinkListViewer2<I, E>(parent);
    }

    public static <I, E> LinkListViewer2<I, E> create(Composite parent, int style) {
        return new LinkListViewer2<I, E>(parent, style);
    }

    public static interface LinkSelectionListener<E> {
        public void selected(E var1);
    }
}

