/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jface;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.smartbear.jface.IActionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;

public class MultiActionProvider
implements IActionProvider<Object> {
    private final Multimap<Class, IActionProvider> actionProviders = LinkedHashMultimap.create();

    public <E> void add(Class<E> elementType, IActionProvider<E> actionProvider) throws IllegalArgumentException {
        Preconditions.checkArgument((elementType != null ? 1 : 0) != 0);
        Preconditions.checkArgument((actionProvider != null ? 1 : 0) != 0);
        this.actionProviders.put(elementType, actionProvider);
    }

    @Override
    public List<IAction> getActions(List<Object> elements) {
        LinkedHashMultimap matching = LinkedHashMultimap.create();
        for (Class elementType : this.actionProviders.keySet()) {
            for (Object element : elements) {
                if (!elementType.isInstance(element)) continue;
                for (IActionProvider actionProvider : this.actionProviders.get((Object)elementType)) {
                    matching.put((Object)actionProvider, element);
                }
            }
        }
        if (matching.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList actions = Lists.newArrayList();
        for (IActionProvider actionProvider : matching.keySet()) {
            actions.addAll(actionProvider.getActions(Lists.newArrayList((Iterable)matching.get((Object)actionProvider))));
        }
        return actions;
    }
}

