/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jface;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.smartbear.jface.EmptyContentProvider;
import com.smartbear.jface.IContentProvider2;
import com.smartbear.jface.IStructuredContentProvider2;
import com.smartbear.jface.ITreeContentProvider2;
import com.smartbear.jface.StructuredViewer2;
import java.util.Collection;
import java.util.Collections;

public class MultiContentProvider<I>
implements ITreeContentProvider2<I, Object, Object> {
    private final Multimap<Class, IStructuredContentProvider2> contentProviders = LinkedHashMultimap.create();
    private IStructuredContentProvider2<I, ?> rootContentProvider = null;

    public void setRoot(IStructuredContentProvider2<I, ?> rootContentProvider) {
        this.rootContentProvider = rootContentProvider;
    }

    public <E> void add(Class<E> elementType, IStructuredContentProvider2<E, ?> contentProvider) throws IllegalArgumentException {
        Preconditions.checkArgument((elementType != null ? 1 : 0) != 0);
        Preconditions.checkArgument((contentProvider != null ? 1 : 0) != 0);
        this.contentProviders.put(elementType, contentProvider);
    }

    public <P> void add(Class<P> elementType, ITreeContentProvider2<I, P, ?> contentProvider) throws IllegalArgumentException {
        Preconditions.checkArgument((elementType != null ? 1 : 0) != 0);
        Preconditions.checkArgument((contentProvider != null ? 1 : 0) != 0);
        this.contentProviders.put(elementType, contentProvider);
    }

    protected Collection<? extends IStructuredContentProvider2> findContentProviders(Object element) {
        for (Class elementType : this.contentProviders.keySet()) {
            if (!elementType.isInstance(element)) continue;
            return this.contentProviders.get((Object)elementType);
        }
        return Collections.singleton(EmptyContentProvider.getInstance());
    }

    @Override
    public void dispose() {
        if (this.rootContentProvider != null) {
            this.rootContentProvider.dispose();
        }
        for (IContentProvider2 contentProvider : this.contentProviders.values()) {
            contentProvider.dispose();
        }
    }

    @Override
    public void inputChanged(StructuredViewer2<I, ?> viewer, I oldInput, I newInput) {
        if (this.rootContentProvider != null) {
            this.rootContentProvider.inputChanged(viewer, oldInput, newInput);
        }
        for (IContentProvider2 contentProvider : this.contentProviders.values()) {
            contentProvider.inputChanged(viewer, oldInput, newInput);
        }
    }

    @Override
    public Collection<? extends Object> getElements(I inputElement) {
        if (this.rootContentProvider != null) {
            return this.rootContentProvider.getElements(inputElement);
        }
        return this.getChildren(inputElement);
    }

    @Override
    public Collection<? extends Object> getChildren(Object parentElement) {
        Collection<Object> children;
        Collection<IStructuredContentProvider2> elementContentProviders = this.findContentProviders(parentElement);
        if (elementContentProviders.size() == 1) {
            IStructuredContentProvider2 contentProvider = elementContentProviders.iterator().next();
            children = contentProvider instanceof ITreeContentProvider2 ? ((ITreeContentProvider2)contentProvider).getChildren(parentElement) : contentProvider.getElements(parentElement);
        } else {
            children = Lists.newArrayList();
            for (IStructuredContentProvider2 contentProvider : elementContentProviders) {
                if (contentProvider instanceof ITreeContentProvider2) {
                    children.addAll(((ITreeContentProvider2)contentProvider).getChildren(parentElement));
                    continue;
                }
                children.addAll(contentProvider.getElements(parentElement));
            }
        }
        return children;
    }

    @Override
    public Object getParent(Object element) {
        Object parent = null;
        for (IStructuredContentProvider2 contentProvider : this.findContentProviders(element)) {
            if (contentProvider instanceof ITreeContentProvider2) {
                parent = ((ITreeContentProvider2)contentProvider).getParent(element);
            }
            if (parent == null) continue;
            break;
        }
        return parent;
    }

    @Override
    public boolean hasChildren(Object element) {
        for (IStructuredContentProvider2 contentProvider : this.findContentProviders(element)) {
            if (!(contentProvider instanceof ITreeContentProvider2 ? ((ITreeContentProvider2)contentProvider).hasChildren(element) : !contentProvider.getElements(element).isEmpty())) continue;
            return true;
        }
        return false;
    }
}

