/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jface;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.smartbear.jface.IBaseLabelProvider2;
import com.smartbear.jface.ILabelProvider2;
import com.smartbear.jface.ITableLabelProvider2;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class MultiLabelProvider
implements ILabelProvider2<Object>,
ITableLabelProvider2<Object> {
    private final Map<Class, ILabelProvider2> labelProviders = new HashMap<Class, ILabelProvider2>();
    private final Map<Class, ITableLabelProvider2> tableLabelProviders = new HashMap<Class, ITableLabelProvider2>();

    public <E> void set(Class<E> elementType, ILabelProvider2<? super E> labelProvider) {
        Preconditions.checkArgument((elementType != null ? 1 : 0) != 0);
        Preconditions.checkArgument((labelProvider != null ? 1 : 0) != 0);
        this.labelProviders.put(elementType, labelProvider);
    }

    public <E> void set(Class<E> elementType, ITableLabelProvider2<? super E> tableLabelProvider) {
        Preconditions.checkArgument((elementType != null ? 1 : 0) != 0);
        Preconditions.checkArgument((tableLabelProvider != null ? 1 : 0) != 0);
        this.tableLabelProviders.put(elementType, tableLabelProvider);
    }

    protected ILabelProvider2 findLabelProvider(Object element) {
        for (Map.Entry<Class, ILabelProvider2> entry : this.labelProviders.entrySet()) {
            if (!entry.getKey().isInstance(element)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected ITableLabelProvider2 findTableLabelProvider(Object element) {
        for (Map.Entry<Class, ITableLabelProvider2> entry : this.tableLabelProviders.entrySet()) {
            if (!entry.getKey().isInstance(element)) continue;
            return entry.getValue();
        }
        return null;
    }

    private Iterable<IBaseLabelProvider2> getAllLabelProviders() {
        return Iterables.concat(this.labelProviders.values(), this.tableLabelProviders.values());
    }

    @Override
    public void addListener(ILabelProviderListener listener) {
        for (IBaseLabelProvider2 labelProvider : this.getAllLabelProviders()) {
            labelProvider.addListener(listener);
        }
    }

    @Override
    public void dispose() {
        for (IBaseLabelProvider2 labelProvider : this.getAllLabelProviders()) {
            labelProvider.dispose();
        }
    }

    @Override
    public boolean isLabelProperty(Object element, String property) {
        ILabelProvider2 labelProvider = this.findLabelProvider(element);
        if (labelProvider != null && labelProvider.isLabelProperty(element, property)) {
            return true;
        }
        ITableLabelProvider2 tableLabelProvider = this.findTableLabelProvider(element);
        return tableLabelProvider != null && tableLabelProvider.isLabelProperty(element, property);
    }

    @Override
    public void removeListener(ILabelProviderListener listener) {
        for (IBaseLabelProvider2 labelProvider : this.getAllLabelProviders()) {
            labelProvider.removeListener(listener);
        }
    }

    @Override
    public Image getImage(Object element) {
        ILabelProvider2 labelProvider = this.findLabelProvider(element);
        if (labelProvider != null) {
            return labelProvider.getImage(element);
        }
        ITableLabelProvider2 tableLabelProvider = this.findTableLabelProvider(element);
        if (tableLabelProvider != null) {
            return tableLabelProvider.getColumnImage(element, 0);
        }
        return null;
    }

    @Override
    public String getText(Object element) {
        ILabelProvider2 labelProvider = this.findLabelProvider(element);
        if (labelProvider != null) {
            return labelProvider.getText(element);
        }
        ITableLabelProvider2 tableLabelProvider = this.findTableLabelProvider(element);
        if (tableLabelProvider != null) {
            return tableLabelProvider.getColumnText(element, 0);
        }
        return "";
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        ILabelProvider2 labelProvider;
        ITableLabelProvider2 tableLabelProvider = this.findTableLabelProvider(element);
        if (tableLabelProvider != null) {
            return tableLabelProvider.getColumnImage(element, columnIndex);
        }
        if (columnIndex == 0 && (labelProvider = this.findLabelProvider(element)) != null) {
            return labelProvider.getImage(element);
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        ILabelProvider2 labelProvider;
        ITableLabelProvider2 tableLabelProvider = this.findTableLabelProvider(element);
        if (tableLabelProvider != null) {
            return tableLabelProvider.getColumnText(element, columnIndex);
        }
        if (columnIndex == 0 && (labelProvider = this.findLabelProvider(element)) != null) {
            return labelProvider.getText(element);
        }
        return "";
    }
}

