/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jface;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.smartbear.jface.IOpenListener2;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiOpenListener
implements IOpenListener2<Object> {
    private final Map<Class, IOpenListener2> openListeners = new HashMap<Class, IOpenListener2>();

    public <E> void set(Class<E> elementType, IOpenListener2<E> openListener) {
        Preconditions.checkArgument((elementType != null ? 1 : 0) != 0);
        Preconditions.checkArgument((openListener != null ? 1 : 0) != 0);
        this.openListeners.put(elementType, openListener);
    }

    @Override
    public void open(List<Object> elements) {
        LinkedHashMap matchingListeners = Maps.newLinkedHashMap();
        for (Object element : elements) {
            for (Map.Entry<Class, IOpenListener2> entry : this.openListeners.entrySet()) {
                if (!entry.getKey().isInstance(element)) continue;
                matchingListeners.put(element, entry.getValue());
            }
        }
        if (matchingListeners.isEmpty()) {
            return;
        }
        LinkedHashMultimap matchingElements = LinkedHashMultimap.create();
        Multimaps.invertFrom((Multimap)Multimaps.forMap((Map)matchingListeners), (Multimap)matchingElements);
        for (IOpenListener2 listener : matchingElements.keySet()) {
            listener.open(Lists.newArrayList((Iterable)matchingElements.get((Object)listener)));
        }
    }
}

