/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jface;

import com.google.common.collect.Lists;
import com.smartbear.jface.IActionProvider;
import com.smartbear.jface.IBaseLabelProvider2;
import com.smartbear.jface.IBaseLabelProviderDelegate;
import com.smartbear.jface.IOpenListener2;
import com.smartbear.jface.IPostSelectionProvider2;
import com.smartbear.jface.ISelectionChangedListener2;
import com.smartbear.jface.IStructuredContentProvider2;
import com.smartbear.jface.LabelProviders;
import com.smartbear.jface.OpenListenerDelegate;
import com.smartbear.jface.SelectionChangedListenerDelegate;
import com.smartbear.jface.StructuredContentProviderDelegate;
import com.smartbear.jface.ViewerComparator2;
import com.smartbear.jface.ViewerComparatorDelegate;
import com.smartbear.jface.ViewerFilter2;
import com.smartbear.jface.ViewerFilterDelegate;
import com.smartbear.util.ComparisonMode;
import com.smartbear.util.ListenerList;
import com.smartbear.util.commons.ArrayUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public abstract class StructuredViewer2<I, E>
implements IPostSelectionProvider2<E> {
    private final StructuredViewer structuredViewer;
    private final ListenerList<SelectionChangedListenerDelegate<E>> selectionChangedListeners = new ListenerList(ComparisonMode.IDENTITY);
    private final ListenerList<SelectionChangedListenerDelegate<E>> postSelectionChangedListeners = new ListenerList(ComparisonMode.IDENTITY);

    protected StructuredViewer2(StructuredViewer inner) {
        this.structuredViewer = inner;
    }

    public StructuredViewer getInner() {
        return this.structuredViewer;
    }

    public Control getControl() {
        return this.structuredViewer.getControl();
    }

    public void setContentProvider(IStructuredContentProvider2<I, E> contentProvider2) {
        this.structuredViewer.setContentProvider(new StructuredContentProviderDelegate<I, E>(this, contentProvider2));
    }

    public IStructuredContentProvider2<I, E> getContentProvider() {
        StructuredContentProviderDelegate delegate = (StructuredContentProviderDelegate)this.structuredViewer.getContentProvider();
        return delegate == null ? null : delegate.contentProvider2;
    }

    public void setLabelProvider(IBaseLabelProvider2<? super E> labelProvider2) {
        this.structuredViewer.setLabelProvider(LabelProviders.getDelegate(labelProvider2));
    }

    public IBaseLabelProvider2<E> getLabelProvider() {
        IBaseLabelProviderDelegate delegate = (IBaseLabelProviderDelegate)this.structuredViewer.getLabelProvider();
        return delegate == null ? null : delegate.getLabelProvider2();
    }

    public void setComparator(ViewerComparator2<E> comparator2) {
        ViewerComparatorDelegate<E> comparator = comparator2 == null ? null : new ViewerComparatorDelegate<E>(comparator2);
        this.structuredViewer.setComparator(comparator);
    }

    public ViewerComparator2<E> getComparator() {
        ViewerComparatorDelegate delegate = (ViewerComparatorDelegate)this.structuredViewer.getComparator();
        return delegate == null ? null : delegate.comparator2;
    }

    public void addFilter(ViewerFilter2<E> filter2) {
        this.structuredViewer.addFilter(new ViewerFilterDelegate<E>(filter2));
    }

    public void removeFilter(ViewerFilter2<E> filter2) {
        ViewerFilterDelegate foundFilter = null;
        for (ViewerFilter filter : this.structuredViewer.getFilters()) {
            if (!(filter instanceof ViewerFilterDelegate) || ((ViewerFilterDelegate)filter).filter2 != filter2) continue;
            foundFilter = (ViewerFilterDelegate)filter;
            break;
        }
        if (foundFilter == null) {
            return;
        }
        this.structuredViewer.removeFilter(foundFilter);
    }

    public List<ViewerFilter2<E>> getFilters() {
        ViewerFilter[] filters = this.structuredViewer.getFilters();
        ArrayList filter2s = Lists.newArrayListWithExpectedSize((int)filters.length);
        for (ViewerFilter filter : filters) {
            filter2s.add(((ViewerFilterDelegate)filter).filter2);
        }
        return filter2s;
    }

    public void setFilters(List<ViewerFilter2<E>> filter2s) {
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)filter2s.size());
        for (ViewerFilter2<E> filter2 : filter2s) {
            filters.add(new ViewerFilterDelegate<E>(filter2));
        }
        this.structuredViewer.setFilters(filters.toArray(ViewerFilterDelegate.EMPTY_VIEWERFILTER_ARRAY));
    }

    public MenuManager setContextMenuProvider(final IActionProvider<E> actionProvider) {
        Menu menu = this.getControl().getMenu();
        if (menu != null && !menu.isDisposed()) {
            menu.dispose();
        }
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (IAction action : actionProvider.getActions(StructuredViewer2.this.getSelection())) {
                    manager.add(action);
                }
            }
        });
        return menuMgr;
    }

    public void setInput(I input) {
        this.structuredViewer.setInput(input);
    }

    public I getInput() {
        return (I)this.structuredViewer.getInput();
    }

    public void refresh() {
        this.structuredViewer.refresh();
    }

    public void refresh(boolean updateLabels) {
        this.structuredViewer.refresh(updateLabels);
    }

    public void refresh(E element) {
        this.structuredViewer.refresh(element);
    }

    public void refresh(E element, boolean updateLabels) {
        this.structuredViewer.refresh(element, updateLabels);
    }

    public void update(E element, List<String> properties) {
        this.structuredViewer.update(element, properties == null ? null : properties.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
    }

    public void update(List<E> elements, List<String> properties) {
        this.structuredViewer.update(elements.toArray(), properties.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
    }

    @Override
    public List<E> getSelection() {
        return ((IStructuredSelection)this.structuredViewer.getSelection()).toList();
    }

    @Override
    public void setSelection(List<E> elements) {
        this.structuredViewer.setSelection((ISelection)new StructuredSelection(elements));
    }

    public void setSelection(List<E> elements, boolean reveal) {
        this.structuredViewer.setSelection((ISelection)new StructuredSelection(elements), reveal);
    }

    private SelectionChangedListenerDelegate<E> findListenerDelegate(ListenerList<SelectionChangedListenerDelegate<E>> selectionChangedListeners, ISelectionChangedListener2<E> listener2) {
        for (SelectionChangedListenerDelegate listener : selectionChangedListeners.getListeners()) {
            if (listener.listener2 != listener2) continue;
            return listener;
        }
        return null;
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener2<E> listener2) {
        SelectionChangedListenerDelegate<E> listener = this.findListenerDelegate(this.selectionChangedListeners, listener2);
        if (listener == null) {
            listener = new SelectionChangedListenerDelegate<E>(listener2);
        }
        this.selectionChangedListeners.add(listener);
        this.structuredViewer.addSelectionChangedListener(listener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener2<E> listener2) {
        SelectionChangedListenerDelegate<E> listener = this.findListenerDelegate(this.selectionChangedListeners, listener2);
        if (listener != null) {
            this.structuredViewer.removeSelectionChangedListener(listener);
            this.selectionChangedListeners.remove(listener);
        }
    }

    @Override
    public void addPostSelectionChangedListener(ISelectionChangedListener2<E> listener2) {
        SelectionChangedListenerDelegate<E> listener = this.findListenerDelegate(this.postSelectionChangedListeners, listener2);
        if (listener == null) {
            listener = new SelectionChangedListenerDelegate<E>(listener2);
        }
        this.postSelectionChangedListeners.add(listener);
        this.structuredViewer.addPostSelectionChangedListener(listener);
    }

    @Override
    public void removePostSelectionChangedListener(ISelectionChangedListener2<E> listener2) {
        SelectionChangedListenerDelegate<E> listener = this.findListenerDelegate(this.postSelectionChangedListeners, listener2);
        if (listener != null) {
            this.structuredViewer.removePostSelectionChangedListener(listener);
            this.postSelectionChangedListeners.remove(listener);
        }
    }

    public void addOpenListener(IOpenListener2<E> listener) {
        this.structuredViewer.addOpenListener(new OpenListenerDelegate<E>(listener));
    }
}

