/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jface;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;

public class ViewerComparator2<E> {
    private Comparator<? super String> comparator;

    public ViewerComparator2() {
        this(null);
    }

    public ViewerComparator2(Comparator<? super String> comparator) {
        this.comparator = comparator;
    }

    protected Comparator<? super String> getComparator() {
        if (this.comparator == null) {
            this.comparator = Collator.getInstance();
        }
        return this.comparator;
    }

    public int category(E element) {
        return 0;
    }

    public int compare(Viewer viewer, E e1, E e2) {
        String name2;
        String name1;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (viewer == null || !(viewer instanceof ContentViewer)) {
            name1 = e1.toString();
            name2 = e2.toString();
        } else {
            IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
            if (prov instanceof ILabelProvider) {
                ILabelProvider lprov = (ILabelProvider)prov;
                name1 = lprov.getText(e1);
                name2 = lprov.getText(e2);
            } else {
                name1 = e1.toString();
                name2 = e2.toString();
            }
        }
        if (name1 == null) {
            name1 = "";
        }
        if (name2 == null) {
            name2 = "";
        }
        return this.getComparator().compare(name1, name2);
    }

    public boolean isSorterProperty(E element, String property) {
        return false;
    }

    public void sort(final Viewer viewer, List<E> elements) {
        Collections.sort(elements, new Comparator<E>(){

            @Override
            public int compare(E a, E b) {
                return ViewerComparator2.this.compare(viewer, a, b);
            }
        });
    }
}

