/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swt;

import com.smartbear.swt.IDragHandler;
import com.smartbear.swt.SwtUtils;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;

public abstract class LocalDragAdapter<T>
extends DragSourceAdapter {
    public static final Transfer[] TRANFER_TYPES = new Transfer[]{LocalSelectionTransfer.getTransfer()};
    private final StructuredViewer viewer;
    private final Class<T> type;
    private final int operations;

    public LocalDragAdapter(StructuredViewer viewer, Class<T> type, int operations) {
        this.viewer = viewer;
        this.type = type;
        this.operations = operations;
    }

    public void dragSetData(DragSourceEvent event) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            LocalSelectionTransfer.getTransfer().setSelection(this.viewer.getSelection());
        }
    }

    public void dragFinished(DragSourceEvent event) {
        if ((event.detail & this.operations) != 0) {
            this.dragFinished(SwtUtils.getMultiSelection(this.viewer.getSelection(), this.type));
        }
    }

    protected abstract void dragFinished(List<T> var1);

    public static <T> void addDragHandler(StructuredViewer viewer, Class<T> type, int operations, final IDragHandler<T> dragHandler) {
        viewer.addDragSupport(operations, TRANFER_TYPES, (DragSourceListener)new LocalDragAdapter<T>(viewer, type, operations){

            @Override
            protected void dragFinished(List<T> elements) {
                dragHandler.dragFinished(elements);
            }
        });
    }
}

