/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swt;

import com.smartbear.collaborator.PlatformUtils;
import com.smartbear.util.commons.ArrayUtils;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class SingleTypeTreeContentProvider<T>
implements ITreeContentProvider {
    private final Class<T> type;
    private boolean disposed = false;
    private AbstractTreeViewer viewer;

    public SingleTypeTreeContentProvider(Class<T> type) {
        this.type = type;
    }

    public final Object[] getElements(Object rawInputElement) {
        Object inputElement = PlatformUtils.CastStrategy.ADAPT.cast(rawInputElement, this.type);
        if (inputElement != null) {
            return this.doGetElements(inputElement).toArray();
        }
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }

    public List<?> doGetElements(T inputElement) {
        return this.doGetChildren(inputElement);
    }

    public final Object[] getChildren(Object rawParentElement) {
        Object parentElement = PlatformUtils.CastStrategy.ADAPT.cast(rawParentElement, this.type);
        if (parentElement != null) {
            return this.doGetChildren(parentElement).toArray();
        }
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }

    public abstract List<?> doGetChildren(T var1);

    public Object getParent(Object element) {
        return null;
    }

    public final boolean hasChildren(Object rawElement) {
        Object element = PlatformUtils.CastStrategy.ADAPT.cast(rawElement, this.type);
        if (element != null) {
            return this.doHasChildren(element);
        }
        return false;
    }

    public boolean doHasChildren(T element) {
        return !this.doGetChildren(element).isEmpty();
    }

    public void dispose() {
        this.disposed = true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (AbstractTreeViewer)viewer;
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    protected AbstractTreeViewer getViewer() {
        return this.viewer;
    }
}

