/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swt;

import com.google.common.collect.Sets;
import com.smartbear.collaborator.PlatformUtils;
import com.smartbear.collaborator.ui.UIName;
import com.smartbear.util.SmartBearUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public final class SwtUtils {
    public static final int BASE_COMPOSITE_STYLE = 0;
    public static final Executor DISPLAY_SYNC_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            Display.getDefault().syncExec(command);
        }
    };
    public static final Control[] EMPTY_CONTROL_ARRAY = new Control[0];
    public static final StyleRange[] EMPTY_STYLE_RANGE_ARRAY = new StyleRange[0];
    private static final StyleRange LINK_STYLE;
    private static final String LINK_MOUSE_TRACK_LISTENERS = "com.smartbear.collaborator.ui.linkMouseTrackListeners";
    private static final String LINK_MOUSE_LISTENERS = "com.smartbear.collaborator.ui.linkMouseListeners";

    private SwtUtils() {
    }

    public static Date toJavaDate(DateTime control) {
        Calendar c = Calendar.getInstance();
        c.set(control.getYear(), control.getMonth(), control.getDay(), control.getHours(), control.getMinutes(), control.getSeconds());
        return c.getTime();
    }

    public static void setDateOnControl(DateTime control, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        control.setYear(cal.get(1));
        control.setMonth(cal.get(2));
        control.setDay(cal.get(5));
        control.setHours(cal.get(11));
        control.setMinutes(cal.get(12));
        control.setSeconds(cal.get(13));
    }

    public static void recursiveAddFocusListener(Control control, FocusListener listener) {
        if (control == null || control.isDisposed() || listener == null) {
            return;
        }
        control.addFocusListener(listener);
        if (control instanceof Composite) {
            for (Control child : ((Composite)control).getChildren()) {
                SwtUtils.recursiveAddFocusListener(child, listener);
            }
        }
    }

    public static void recursiveRemoveFocusListener(Control control, FocusListener listener) {
        if (control == null || control.isDisposed() || listener == null) {
            return;
        }
        control.removeFocusListener(listener);
        if (control instanceof Composite) {
            for (Control child : ((Composite)control).getChildren()) {
                SwtUtils.recursiveRemoveFocusListener(child, listener);
            }
        }
    }

    public static void reflowForm(Control control) {
        if (control == null) {
            return;
        }
        if (control instanceof SharedScrolledComposite) {
            ((SharedScrolledComposite)control).reflow(true);
        } else {
            SwtUtils.reflowForm((Control)control.getParent());
        }
    }

    public static void recursiveAdapt(FormToolkit formToolkit, Control control, boolean trackFocus, boolean trackKeyboard, boolean preserveBackgroundColor, boolean preserveMenu) {
        if (control instanceof Composite) {
            SwtUtils.adapt(formToolkit, (Composite)control, preserveBackgroundColor, preserveMenu);
            for (Control child : ((Composite)control).getChildren()) {
                SwtUtils.recursiveAdapt(formToolkit, child, trackFocus, trackKeyboard, preserveBackgroundColor, preserveMenu);
            }
        } else {
            SwtUtils.adapt(formToolkit, control, trackFocus, trackKeyboard, preserveBackgroundColor, preserveMenu);
        }
    }

    public static void adapt(FormToolkit formToolkit, Composite composite, boolean preserveBackgroundColor, boolean preserveMenu) {
        Color backgroundColor = null;
        if (preserveBackgroundColor) {
            backgroundColor = composite.getBackground();
        }
        Menu menu = null;
        if (preserveMenu) {
            menu = composite.getMenu();
        }
        formToolkit.adapt(composite);
        if (preserveBackgroundColor) {
            composite.setBackground(backgroundColor);
        }
        if (preserveMenu) {
            composite.setMenu(menu);
        }
    }

    public static void adapt(FormToolkit formToolkit, Control control, boolean trackFocus, boolean trackKeyboard, boolean preserveBackgroundColor, boolean preserveMenu) {
        Color backgroundColor = null;
        if (preserveBackgroundColor) {
            backgroundColor = control.getBackground();
        }
        Menu menu = null;
        if (preserveMenu) {
            menu = control.getMenu();
        }
        formToolkit.adapt(control, trackFocus, trackKeyboard);
        if (preserveBackgroundColor) {
            control.setBackground(backgroundColor);
        }
        if (preserveMenu) {
            control.setMenu(menu);
        }
    }

    public static String escapeMnemonics(String str) {
        return StringUtils.replace((String)str, (String)"&", (String)"&&");
    }

    public static <L extends Layout> void setMargins(L layout, int margin) {
        if (layout instanceof FillLayout) {
            FillLayout fillLayout = (FillLayout)layout;
            fillLayout.marginHeight = margin;
            fillLayout.marginWidth = margin;
        }
        if (layout instanceof RowLayout) {
            RowLayout rowLayout = (RowLayout)layout;
            rowLayout.marginTop = margin;
            rowLayout.marginBottom = margin;
            rowLayout.marginLeft = margin;
            rowLayout.marginRight = margin;
        }
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginHeight = margin;
            gridLayout.marginWidth = margin;
        }
        if (layout instanceof FormLayout) {
            FormLayout formLayout = (FormLayout)layout;
            formLayout.marginHeight = margin;
            formLayout.marginWidth = margin;
        }
        if (layout instanceof TableWrapLayout) {
            TableWrapLayout tableWrapLayout = (TableWrapLayout)layout;
            tableWrapLayout.topMargin = margin;
            tableWrapLayout.bottomMargin = margin;
            tableWrapLayout.leftMargin = margin;
            tableWrapLayout.rightMargin = margin;
        }
        if (layout instanceof ColumnLayout) {
            ColumnLayout columnLayout = (ColumnLayout)layout;
            columnLayout.topMargin = margin;
            columnLayout.bottomMargin = margin;
            columnLayout.leftMargin = margin;
            columnLayout.rightMargin = margin;
        }
        if (layout instanceof StackLayout) {
            StackLayout stackLayout = (StackLayout)layout;
            stackLayout.marginHeight = margin;
            stackLayout.marginWidth = margin;
        }
    }

    public static <T> T getSelection(ISelection selection, Class<T> type) {
        return SwtUtils.getSelection(selection, type, PlatformUtils.CastStrategy.ADAPT);
    }

    public static <T> T getSelection(ISelection selection, Class<T> type, PlatformUtils.CastStrategy castStrategy) {
        return (T)SmartBearUtils.getFirstObject(SwtUtils.getMultiSelection(selection, type, castStrategy));
    }

    public static <T> List<T> getMultiSelection(ISelection selection, Class<T> type) {
        return SwtUtils.getMultiSelection(selection, type, PlatformUtils.CastStrategy.ADAPT);
    }

    public static <T> List<T> getMultiSelection(ISelection selection, Class<T> type, PlatformUtils.CastStrategy castStrategy) {
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            Object selectedElement = castStrategy.cast((Object)selection, type);
            if (selectedElement != null) {
                return Collections.singletonList(selectedElement);
            }
            return Collections.emptyList();
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object[] selectedElements = structuredSelection.toArray();
        if (selectedElements == null || selectedElements.length == 0) {
            return Collections.emptyList();
        }
        if (selectedElements.length == 1) {
            Object selectedElement = castStrategy.cast(selectedElements[0], type);
            if (selectedElement != null) {
                return Collections.singletonList(selectedElement);
            }
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(selectedElements.length);
        for (Object rawSelectedElement : selectedElements) {
            Object selectedElement = castStrategy.cast(rawSelectedElement, type);
            if (selectedElement == null) continue;
            list.add(selectedElement);
        }
        return list;
    }

    public static int getTextWidth(String text, GC gc) {
        return gc.stringExtent((String)StringUtils.defaultString((String)text)).x;
    }

    public static void resizeVerticalIfNecessary(Control control) {
        int desiredHeight = control.computeSize((int)control.getBounds().width, (int)-1, (boolean)true).y;
        if (desiredHeight != control.getBounds().height) {
            SwtUtils.reflowForm(control);
        }
    }

    public static boolean isFocusAncestor(Composite composite) {
        for (Control control = composite.getDisplay().getFocusControl(); control != null && !control.isDisposed(); control = control.getParent()) {
            if (control != composite) continue;
            return true;
        }
        return false;
    }

    public static void addStyle(StyledText text, StyleRange styleRange) {
        StyleRange[] baseStyleRanges = text.getStyleRanges();
        TextPresentation merger = new TextPresentation(baseStyleRanges.length + 1);
        for (StyleRange baseStyleRange : baseStyleRanges) {
            merger.addStyleRange(baseStyleRange);
        }
        merger.mergeStyleRange(styleRange);
        TextPresentation.applyTextPresentation((TextPresentation)merger, (StyledText)text);
    }

    public static void addLink(final StyledText text, final int start, final int end, final String toolTipText, final Runnable action) {
        Set listeners;
        Object listener;
        StyleRange styleRange = new StyleRange((TextStyle)LINK_STYLE);
        styleRange.start = start;
        styleRange.length = end - start;
        SwtUtils.addStyle(text, styleRange);
        if (toolTipText != null) {
            listener = new MouseTrackAdapter(){

                public void mouseHover(MouseEvent e) {
                    if (!SwtUtils.isMouseInRange(text, start, end, e)) {
                        return;
                    }
                    DefaultToolTip toolTip = new DefaultToolTip((Control)text, 0, true);
                    toolTip.setText(toolTipText);
                    toolTip.show(new Point(e.x, e.y));
                }
            };
            text.addMouseTrackListener((MouseTrackListener)listener);
            listeners = (Set)text.getData(LINK_MOUSE_TRACK_LISTENERS);
            if (listeners == null) {
                listeners = Sets.newHashSetWithExpectedSize((int)3);
                text.setData(LINK_MOUSE_TRACK_LISTENERS, (Object)listeners);
            }
            listeners.add(listener);
        }
        listener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!SwtUtils.isMouseInRange(text, start, end, e)) {
                    return;
                }
                action.run();
            }
        };
        text.addMouseListener((MouseListener)listener);
        listeners = (Set)text.getData(LINK_MOUSE_LISTENERS);
        if (listeners == null) {
            listeners = Sets.newHashSetWithExpectedSize((int)3);
            text.setData(LINK_MOUSE_LISTENERS, (Object)listeners);
        }
        listeners.add(listener);
    }

    public static void clearStylesAndLinks(StyledText text) {
        text.setStyleRange(null);
        Set mouseTrackListeners = (Set)text.getData(LINK_MOUSE_TRACK_LISTENERS);
        if (mouseTrackListeners != null) {
            for (MouseTrackListener listener : mouseTrackListeners) {
                text.removeMouseTrackListener(listener);
            }
        }
        text.setData(LINK_MOUSE_TRACK_LISTENERS, null);
        Set mouseListeners = (Set)text.getData(LINK_MOUSE_LISTENERS);
        if (mouseListeners != null) {
            for (MouseTrackListener listener : mouseListeners) {
                text.removeMouseListener((MouseListener)listener);
            }
        }
        text.setData(LINK_MOUSE_LISTENERS, null);
    }

    private static boolean isMouseInRange(StyledText text, int start, int end, MouseEvent e) {
        int offset;
        Point location = new Point(e.x, e.y);
        if (text != e.widget) {
            return false;
        }
        try {
            offset = text.getOffsetAtLocation(location);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return start <= offset && offset <= end;
    }

    public static void setName(Widget widget, UIName name) {
        if (widget == null || name == null) {
            return;
        }
        if (widget.getData() != null) {
            return;
        }
        widget.setData((Object)name.name());
    }

    static {
        StyleRange styleRange = new StyleRange();
        styleRange.underline = true;
        styleRange.underlineStyle = 4;
        LINK_STYLE = styleRange;
    }
}

