/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swt.text;

import com.google.common.collect.Lists;
import com.smartbear.swt.text.IStyledTextDecorator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.StyledText;

public class CompositeStyledTextDecorator
implements IStyledTextDecorator {
    final List<IStyledTextDecorator> decorators;

    public CompositeStyledTextDecorator() {
        this(Collections.emptyList());
    }

    private CompositeStyledTextDecorator(List<IStyledTextDecorator> decorators) {
        this.decorators = Lists.newArrayList(decorators);
    }

    public void add(IStyledTextDecorator decorator) {
        this.decorators.add(decorator);
    }

    public void remove(IStyledTextDecorator decorator) {
        this.decorators.remove(decorator);
    }

    @Override
    public void decorate(StyledText text) {
        for (IStyledTextDecorator decorator : this.decorators) {
            decorator.decorate(text);
        }
    }

    public static CompositeStyledTextDecorator of(IStyledTextDecorator ... decorators) {
        return new CompositeStyledTextDecorator(Arrays.asList(decorators));
    }
}

