/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ccvs;

import com.smartbear.cmdline.ScmCommunicationException;
import com.smartbear.collaborator.team.SubscriberClientConfiguration;
import com.smartbear.scm.IScmChangelist;
import com.smartbear.scm.IScmCommitInfo;
import com.smartbear.scm.IScmConnectionParameters;
import com.smartbear.scm.IScmLocalCheckout;
import com.smartbear.scm.IScmSystem;
import com.smartbear.scm.IScmVersion;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.ScmUtils;
import com.smartbear.scm.impl.common.ScmConnectionParameters;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;

public class CVSProviderClientConfiguration
extends SubscriberClientConfiguration {
    private static final Log LOG = LogFactory.getLog(CVSProviderClientConfiguration.class);
    private final ICVSRepositoryLocation remoteLocation;

    public CVSProviderClientConfiguration(ICVSRepositoryLocation remoteLocation) {
        super((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
        this.remoteLocation = remoteLocation;
    }

    public String getDisplayableConfiguration() {
        return ((CVSRepositoryLocation)this.remoteLocation).getLocation(true);
    }

    protected boolean isIgnored(IFile file) throws ScmCommunicationException {
        try {
            ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
            return cvsFile == null || cvsFile.isIgnored();
        }
        catch (CVSException e) {
            throw new ScmCommunicationException((Exception)((Object)e));
        }
    }

    protected String getDisplayPath(IFile file) throws ScmCommunicationException {
        try {
            ICVSResource cvsProject = CVSWorkspaceRoot.getCVSResourceFor((IResource)file.getProject());
            return "/" + cvsProject.getRepositoryRelativePath() + "/" + file.getProjectRelativePath();
        }
        catch (CVSException e) {
            throw new ScmCommunicationException("Could not get repository relative path", (Throwable)e);
        }
    }

    private ILogEntry getLogEntry(IResourceVariant resourceVariant, IProgressMonitor monitor) throws ScmCommunicationException {
        try {
            ICVSRemoteFile remoteFile = (ICVSRemoteFile)resourceVariant;
            return remoteFile.getLogEntry(monitor);
        }
        catch (TeamException e) {
            throw new ScmCommunicationException("Could not get cvs log information for file " + resourceVariant, (Throwable)e);
        }
    }

    protected String getAuthor(IResourceVariant resourceVariant, IProgressMonitor monitor) throws ScmCommunicationException {
        return this.getLogEntry(resourceVariant, monitor).getAuthor();
    }

    protected Date getDate(IResourceVariant resourceVariant, IProgressMonitor monitor) throws ScmCommunicationException {
        return this.getLogEntry(resourceVariant, monitor).getDate();
    }

    protected IScmCommitInfo.State getState(IResourceVariant resourceVariant, IProgressMonitor monitor) throws ScmCommunicationException {
        String revision = this.getLogEntry(resourceVariant, monitor).getRevision();
        return revision.startsWith("1.1") ? IScmCommitInfo.State.ADDING : IScmCommitInfo.State.CONTROLLED;
    }

    public IScmSystem getScmSystem() {
        return ScmUtils.getScmSystemFromToken((String)"cvs");
    }

    public IScmConnectionParameters getServerConfiguration(IScmLocalCheckout checkout, IScmVersion version, IScmChangelist atomicChange) throws ScmConfigurationException {
        String host = this.remoteLocation.getHost();
        String path = this.remoteLocation.getRootDirectory();
        return new ScmConnectionParameters(host, path);
    }

    public String getUserName() {
        return this.remoteLocation.getUsername();
    }

    public void logStatus(IProgressMonitor monitor) throws ScmCommunicationException {
        super.logStatus(monitor);
        LOG.debug((Object)this.remoteLocation);
        LOG.debug((Object)((CVSRepositoryLocation)this.remoteLocation).getLocation(true));
    }

    public void setConfiguration(Properties params, boolean forceCurrent) throws ScmConfigurationException {
        throw new ScmConfigurationException("Cannot configure Eclipse CVS client");
    }

    public IScmChangelist getChangelist(String id, IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }

    public IScmChangelist[] getLocalChangelists(IProgressMonitor monitor) throws ScmCommunicationException {
        return null;
    }
}

