/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.git;

import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.git.GitConnectorClient;
import com.smartbear.collaborator.team.IResourceScmClientConfiguration;
import com.smartbear.collaborator.team.ResourceScmClientConfigurationWrapper;
import com.smartbear.collaborator.team.scm.IResourceScmClientConfigurationFactory;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.ScmConfigurationException;
import com.smartbear.scm.impl.git.GitClientConfiguration;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.RepositoryProvider;

public class GitClientConfigurationFactory
implements IResourceScmClientConfigurationFactory {
    public IResourceScmClientConfiguration getClientConfiguration(RepositoryProvider provider, IProgressMonitor monitor) throws ScmConfigurationException {
        try {
            if (!(provider instanceof GitProvider)) {
                throw new RuntimeException("Expected GitProvider: " + provider);
            }
            GitProvider gitProvider = (GitProvider)provider;
            GitProjectData projectData = gitProvider.getData();
            if (projectData == null) {
                return null;
            }
            IProject project = provider.getProject();
            RepositoryMapping mapping = projectData.getRepositoryMapping((IResource)project);
            if (mapping == null) {
                return null;
            }
            Repository db = mapping.getRepository();
            return new ResourceScmClientConfigurationWrapper((IScmClientConfiguration)GitClientConfigurationFactory.getClientConfiguration(db));
        }
        catch (CollabClientException e) {
            CollaboratorUI.log((String)"Error in adding the changed files to the Review", (Throwable)e);
            throw new ScmConfigurationException(e.getMessage());
        }
    }

    public static IScmOptions getScmOptions(File repositoryLocation) {
        ScmOptions options = new ScmOptions();
        options.setScm("git");
        options.setGitRepository(repositoryLocation);
        return options;
    }

    public static GitClientConfiguration getClientConfiguration(Repository repository) throws CollabClientException {
        GitConnectorClient connector = new GitConnectorClient(repository);
        return connector;
    }
}

