/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.git.handlers;

import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.git.GitConnectorChangelist;
import com.smartbear.collaborator.git.GitConnectorUtils;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.git.GitClientConfigurationFactory;
import com.smartbear.collaborator.ui.ide.actions.AbstractAddToReviewHandler;
import com.smartbear.collaborator.ui.util.PlatformUIUtils;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.collaborator.ui.wizards.SubmittedChangelistsSelectionPage;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.impl.git.GitClientConfiguration;
import com.smartbear.scm.impl.git.LogEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddCommitToReviewHandler
extends AbstractAddToReviewHandler
implements IHandler {
    public AddCommitToReviewHandler() {
        super("Add Commits");
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(true);
    }

    public boolean isHandled() {
        return true;
    }

    protected IChangesSelectionPage getChangesSelectionPage(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(event);
        ScmOptions options = new ScmOptions();
        options.setScm("git");
        options.setGitRepository(repository.getWorkTree());
        try {
            GitClientConfiguration clientConfig = GitClientConfigurationFactory.getClientConfiguration(repository);
            List selection = PlatformUIUtils.getMultiSelection((ExecutionEvent)event, RevCommit.class);
            List<Object> gitChangeList = new ArrayList();
            if (selection == null) {
                gitChangeList = Collections.emptyList();
            } else {
                for (RevCommit revCommit : selection) {
                    LogEntry entry = GitConnectorUtils.convertRevCommitToLogEntry((Repository)repository, (RevCommit)revCommit);
                    GitConnectorChangelist gitConnectorChangelist = new GitConnectorChangelist(clientConfig, entry);
                    gitChangeList.add(gitConnectorChangelist);
                }
            }
            return new SubmittedChangelistsSelectionPage((IScmClientConfiguration)clientConfig, (IStructuredSelection)new StructuredSelection(gitChangeList), (IScmOptions)options);
        }
        catch (CollabClientException e) {
            CollaboratorUI.log((String)"Error in adding the commit to the Review", (Throwable)e);
            throw new ExecutionException("Error in adding the commit to the Review", (Throwable)e);
        }
    }

    private IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    private Object getInput(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = this.getPart(event);
        if (!(part instanceof IHistoryView)) {
            throw new ExecutionException(UIText.AbstractHistoryCommanndHandler_NoInputMessage);
        }
        return ((IHistoryView)part).getHistoryPage().getInput();
    }

    private Repository getRepository(ExecutionEvent event) throws ExecutionException {
        IResource resource;
        RepositoryMapping mapping;
        Object input = this.getInput(event);
        if (input == null) {
            return null;
        }
        if (input instanceof HistoryPageInput) {
            return ((HistoryPageInput)input).getRepository();
        }
        if (input instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)input).getRepository();
        }
        if (input instanceof IResource && (mapping = RepositoryMapping.getMapping((IResource)(resource = (IResource)input))) != null) {
            return mapping.getRepository();
        }
        if (input instanceof IAdaptable && (resource = (IResource)((IAdaptable)input).getAdapter(IResource.class)) != null && (mapping = RepositoryMapping.getMapping((IResource)resource)) != null) {
            return mapping.getRepository();
        }
        Repository repo = (Repository)Adapters.adapt((Object)input, Repository.class);
        if (repo != null) {
            return repo;
        }
        throw new ExecutionException(UIText.AbstractHistoryCommanndHandler_CouldNotGetRepositoryMessage);
    }
}

