/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.collaborator.ui.git.handlers;

import com.smartbear.beans.IScmOptions;
import com.smartbear.beans.ScmOptions;
import com.smartbear.ccollab.client.commands.diffs.CommandAddGitDiffs;
import com.smartbear.collaborator.client.exceptions.CollabClientException;
import com.smartbear.collaborator.git.GitConnectorClient;
import com.smartbear.collaborator.ui.CollaboratorUI;
import com.smartbear.collaborator.ui.ScmConfig;
import com.smartbear.collaborator.ui.diffs.GitBranchesDiffBuilder;
import com.smartbear.collaborator.ui.git.GitClientConfigurationFactory;
import com.smartbear.collaborator.ui.ide.jobs.ReviewFinishedHandler;
import com.smartbear.collaborator.ui.wizards.AddToReviewWizard;
import com.smartbear.collaborator.ui.wizards.DiffChangesSelectionPage;
import com.smartbear.collaborator.ui.wizards.IChangesSelectionPage;
import com.smartbear.collaborator.ui.wizards.ProgressWizardDialog;
import com.smartbear.scm.IScmClientConfiguration;
import com.smartbear.scm.impl.git.GitClientConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddDiffBranchToReviewHandler
extends AbstractHandler
implements IHandler {
    private IEvaluationContext evaluationContext;
    private final String titlePrefix;
    AddToReviewWizard wizard;
    List<String> branches;

    public AddDiffBranchToReviewHandler() {
        this.titlePrefix = "Add Diff Branches";
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(true);
        this.evaluationContext = evaluationContext instanceof IEvaluationContext ? (IEvaluationContext)evaluationContext : null;
    }

    public boolean isHandled() {
        return true;
    }

    protected IChangesSelectionPage getChangesSelectionPage(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(event);
        try {
            GitClientConfiguration clientConfig = GitClientConfigurationFactory.getClientConfiguration(repository);
            ((GitConnectorClient)clientConfig).setBranches(this.branches);
            GitBranchesDiffBuilder gitBranchesDiffBuider = new GitBranchesDiffBuilder((IScmClientConfiguration)clientConfig);
            List<GitBranchesDiffBuilder> diffBuilders = Collections.singletonList(gitBranchesDiffBuider);
            ScmOptions options = new ScmOptions();
            ScmConfig scmConfig = new ScmConfig((IScmOptions)options);
            DiffChangesSelectionPage changesPage = new DiffChangesSelectionPage((IScmClientConfiguration)clientConfig, CommandAddGitDiffs.DESCRIPTOR, scmConfig, diffBuilders);
            this.wizard = new AddToReviewWizard("Add Git Diffs", (IChangesSelectionPage)changesPage);
            gitBranchesDiffBuider.setWizard((Wizard)this.wizard);
            return changesPage;
        }
        catch (CollabClientException e) {
            throw new ExecutionException("Error loading client config", (Throwable)e);
        }
    }

    public List<RepositoryTreeNode> getSelectedNodes(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    private String getRefName(RepositoryTreeNode node) {
        Object object = node.getObject();
        if (!(object instanceof Ref)) {
            return null;
        }
        Ref ref = (Ref)object;
        return ref.getName();
    }

    private Repository getRepository(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode node = this.getSelectedNodes(event).get(0);
        String refName = this.getRefName(node);
        if (refName == null) {
            return null;
        }
        String secondRefName = "HEAD";
        if (this.getSelectedNodes(event).size() == 2 && (secondRefName = this.getRefName(this.getSelectedNodes(event).get(1))) == null) {
            return null;
        }
        this.branches = new ArrayList<String>();
        this.branches.add(refName);
        this.branches.add(secondRefName);
        String secondRefNameParam = secondRefName;
        boolean includeLocal = this.getSelectedNodes(event).size() == 1;
        Repository repo = node.getRepository();
        return repo;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IChangesSelectionPage changesPage = this.getChangesSelectionPage(event);
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        try {
            this.wizard.setJobListener((IJobChangeListener)new ReviewFinishedHandler());
            ProgressWizardDialog dlg = new ProgressWizardDialog(shell, (IWizard)this.wizard);
            dlg.open();
        }
        catch (Throwable e) {
            CollaboratorUI.log((String)"Error in adding diff from the branches to the Review!", (Throwable)e);
            throw new ExecutionException("Error in adding diff from the branches to the Review!", e);
        }
        return null;
    }
}

